<?php
/**
 * The main template file.
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package politics-plus
 */

get_header();

$blog_sidebar_position = get_theme_mod( 'blog_sidebar_position', customizer_library_get_default( 'blog_sidebar_position' ) ); ?>

<div class="row">

  <?php if( $blog_sidebar_position == 'left' ) { ?>
    <div class="large-3 columns inner-sidebar">
      <?php get_sidebar(); ?>
    </div><!-- .large-3 -->
  <?php } ?>

  <div class="large-8 <?php if ( $blog_sidebar_position == 'left' ) { echo 'offset-1' }; ?> columns">

	<div id="primary" class="content-area">
		<main id="main" class="site-main" role="main">

		<?php if ( have_posts() ) : ?>

			<?php if ( is_home() && ! is_front_page() ) : ?>
				<header>
					<h1 class="page-title screen-reader-text"><?php single_post_title(); ?></h1>
				</header>
			<?php endif; ?>

			<?php /* Start the Loop */ ?>
			<?php while ( have_posts() ) : the_post(); ?>

				<?php

					/*
					 * Include the Post-Format-specific template for the content.
					 * If you want to override this in a child theme, then include a file
					 * called content-___.php (where ___ is the Post Format name) and that will be used instead.
					 */
					get_template_part( 'template-parts/content', get_post_format() );
				?>

			<?php endwhile; ?>

			<?php the_posts_navigation(); ?>

		<?php else : ?>

			<?php get_template_part( 'template-parts/content', 'none' ); ?>

		<?php endif; ?>

		</main><!-- #main -->
	</div><!-- #primary -->

</div><!-- .large-8 -->

<?php if ( $blog_sidebar_position == 'right' ) { ?>
<div class="large-3 offset-1 columns inner-sidebar">

	<?php get_sidebar(); ?>

</div><!-- .large-3 .offset-1 -->
<?php } ?>

</div><!-- .row -->

<?php get_footer(); ?>
