<?php

  /**
   * Declare WooCommerce support
   */
  add_action( 'after_setup_theme', 'politics_plus_woocommerce_support' );
  function politics_plus_woocommerce_support() {
      add_theme_support( 'woocommerce' );
      add_theme_support( 'wc-product-gallery-zoom' );
      add_theme_support( 'wc-product-gallery-lightbox' );
	  add_theme_support( 'wc-product-gallery-slider' );
  }

  /**
   * Enqueue shop stylesheet
   */
 	$politics_plus = wp_get_theme();

  function politics_plus_shop_scripts() {

    $politics_plus = wp_get_theme();

    wp_enqueue_style( 'politics-plus-shop', get_template_directory_uri() . '/css/shop.css', array(), $politics_plus['Version'], 'all' );
  }
  add_action( 'wp_enqueue_scripts', 'politics_plus_shop_scripts' );

  /**
   * Unhook main content wrappers
   */
  remove_action( 'woocommerce_before_main_content', 'woocommerce_output_content_wrapper', 10);
  remove_action( 'woocommerce_after_main_content', 'woocommerce_output_content_wrapper_end', 10);

  /**
   * Hook theme main content wrappers
   */
  add_action('woocommerce_before_main_content', 'politics_plus_wrapper_start', 10);
  function politics_plus_wrapper_start() {
    echo '<div class="row">';
    echo '<div class="large-8 columns">';
    echo '<div id="primary" class="content-area">';
  }

  add_action('woocommerce_after_main_content', 'politics_plus_wrapper_end', 10);
  function politics_plus_wrapper_end() {
    echo '</div><!-- .content-area -->';
    echo '</div><!-- .large-8 -->';
  }

  /**
   * Unhook WooCommerce sidebar & add theme wrappers
   */
  remove_action( 'woocommerce_sidebar', 'woocommerce_get_sidebar', 10 );

  /**
   * Hook theme shop sidebar
   */
  add_action( 'woocommerce_sidebar', 'politics_plus_shop_sidebar', 10 );
  function politics_plus_shop_sidebar(){
    echo '<div class="large-3 offset-1 columns inner-sidebar">';
      dynamic_sidebar( 'shop-sidebar' );
    echo '</div><!-- .large-3 -->';
    echo '</div><!-- .row -->';
  }

?>
