<?php
/**
 * Easy Digital Downloads Theme Updater
 *
 * @package EDD Sample Theme
 */

// Includes the files needed for the theme updater
if ( !class_exists( 'EDD_Theme_Updater_Admin' ) ) {
	include( dirname( __FILE__ ) . '/theme-updater-admin.php' );
}

// Loads the updater classes
$updater = new EDD_Theme_Updater_Admin(

	// Config settings
	$config = array(
		'remote_api_url' => 'https://rescuethemes.com', // Site where EDD is hosted
		'item_name'      => 'Politics Plus', // Name of theme
		'theme_slug'     => 'politics-plus', // Theme slug
		'version'        => '1.2', // The current version of this theme
		'author'         => 'Rescue Themes', // The author of this theme
		'download_id'    => '5687', // Optional, used for generating a license renewal link
		'renew_url'      => '', // Optional, allows for a custom license renewal link
		'beta'           => false, // Optional, set to true to opt into beta versions
	),

	// Strings
	$strings = array(
		'theme-license'             => __( 'Theme License', 'politics-plus' ),
		'enter-key'                 => __( 'Enter your theme license key.', 'politics-plus' ),
		'license-key'               => __( 'License Key', 'politics-plus' ),
		'license-action'            => __( 'License Action', 'politics-plus' ),
		'deactivate-license'        => __( 'Deactivate License', 'politics-plus' ),
		'activate-license'          => __( 'Activate License', 'politics-plus' ),
		'status-unknown'            => __( 'License status is unknown.', 'politics-plus' ),
		'renew'                     => __( 'Renew?', 'politics-plus' ),
		'unlimited'                 => __( 'unlimited', 'politics-plus' ),
		'license-key-is-active'     => __( 'License key is active.', 'politics-plus' ),
		'expires%s'                 => __( 'Expires %s.', 'politics-plus' ),
		'expires-never'             => __( 'Lifetime License.', 'politics-plus' ),
		'%1$s/%2$-sites'            => __( 'You have %1$s / %2$s sites activated.', 'politics-plus' ),
		'license-key-expired-%s'    => __( 'License key expired %s.', 'politics-plus' ),
		'license-key-expired'       => __( 'License key has expired.', 'politics-plus' ),
		'license-keys-do-not-match' => __( 'License keys do not match.', 'politics-plus' ),
		'license-is-inactive'       => __( 'License is inactive.', 'politics-plus' ),
		'license-key-is-disabled'   => __( 'License key is disabled.', 'politics-plus' ),
		'site-is-inactive'          => __( 'Site is inactive.', 'politics-plus' ),
		'license-status-unknown'    => __( 'License status is unknown.', 'politics-plus' ),
		'update-notice'             => __( "Updating this theme will lose any customizations you have made. 'Cancel' to stop, 'OK' to update.", 'politics-plus' ),
		'update-available'          => __('<strong>%1$s %2$s</strong> is available. <a href="%3$s" class="thickbox" title="%4s">Check out what\'s new</a> or <a href="%5$s"%6$s>update now</a>.', 'politics-plus' ),
	)

);
