<?php
/**
 * Implements styles set in the theme customizer
 *
 * @package Customizer Library Demo
 */

/*--------------------------------------------------------------
>>> TABLE OF CONTENTS:
----------------------------------------------------------------

1.0 Header
2.0 Home
3.0 Footer
4.0 Blog
5.0 Typography
	5.1 Typography: Global
	5.2 Typography: Headers
	5.3 Typography: Site Title & Tagline
	5.4 Typography: Navigation
	5.5 Typography: Sidebar
	5.6 Typography: Footer
	5.7 Typography: Copyright
6.0 Colors
	6.1 Colors: Sitewide
	6.2 Colors: Navigation
	6.3 Colors: Title & Tagline
	6.4 Colors: Sidebar
	6.5 Colors: Footer

 --------------------------------------------------------------*/

if ( ! function_exists( 'customizer_library_demo_build_styles' ) && class_exists( 'Customizer_Library_Styles' ) ) :
/**
 * Process user options to generate CSS needed to implement the choices.
 *
 * @since  1.0.0.
 *
 * @return void
 */
function customizer_library_demo_build_styles() {

/*--------------------------------------------------------------
 2.0 Home
--------------------------------------------------------------*/
	// Home Hero Overly Color
	$setting = 'home_overlay_color';
	$mod = get_theme_mod( $setting, customizer_library_get_default( $setting ) );

	if ( $mod !== customizer_library_get_default( $setting ) ) {

		$color = sanitize_hex_color( $mod );

		Customizer_Library_Styles()->add( array(
			'selectors' => array(
				'.color-overlay:before'
			),
			'declarations' => array(
				'background-color' => $color
			)
		) );
	}

	// Home Hero Opacity Level
	$setting = 'home_opacity';
	$mod = get_theme_mod( $setting, customizer_library_get_default( $setting ) );

	if ( $mod !== customizer_library_get_default( $setting ) ) {

		$numeral = customizer_library_sanitize_text( $mod );

		Customizer_Library_Styles()->add( array(
			'selectors' => array(
				'.color-overlay:before'
			),
			'declarations' => array(
				'opacity' => $numeral
			)
		) );
	}

/*--------------------------------------------------------------
 5.0 Typography
--------------------------------------------------------------*/

/*--------------------------------------------------------------
 5.1 Typography: Global
--------------------------------------------------------------*/
	// Link Font Weight
	$setting = 'type-global-links-weight';
	$mod = get_theme_mod( $setting, customizer_library_get_default( $setting ) );

	if ( $mod !== customizer_library_get_default( $setting ) ) {

		$text = customizer_library_sanitize_text( $mod );

		Customizer_Library_Styles()->add( array(
			'selectors' => array(
				'#content a, .footer-wrap a'
			),
			'declarations' => array(
				'font-weight' => $text
			)
		) );
	}

	// Link Underline
	$setting = 'type-global-links-underline';
	$mod = get_theme_mod( $setting, customizer_library_get_default( $setting ) );

	if ( $mod !== customizer_library_get_default( $setting ) ) {

		$text = customizer_library_sanitize_text( $mod );

		Customizer_Library_Styles()->add( array(
			'selectors' => array(
				'#content a, .footer-wrap a'
			),
			'declarations' => array(
				'text-decoration' => $text
			)
		) );
	}

/*--------------------------------------------------------------
 5.2 Typography: Headers
--------------------------------------------------------------*/
// Font Family
$setting = 'type-header-font-family';
$mod = get_theme_mod( $setting, customizer_library_get_default( $setting ) );

$stack = customizer_library_get_font_stack( $mod );

if ( $mod != customizer_library_get_default( $setting ) ) {

	Customizer_Library_Styles()->add( array(
		'selectors' => array(
			'h1, h2, h3, h4, h5, h6'
		),
		'declarations' => array(
			'font-family' => $stack
		)
	) );

}

// Font Weight
$setting = 'type-header-font-weight';
$mod = get_theme_mod( $setting, customizer_library_get_default( $setting ) );

if ( $mod !== customizer_library_get_default( $setting ) ) {

	$text = customizer_library_sanitize_text( $mod );

	Customizer_Library_Styles()->add( array(
		'selectors' => array(
			'h1, h2, h3, h4, h5, h6'
		),
		'declarations' => array(
			'font-weight' => $text
		)
	) );
}

// Font Style
$setting = 'type-header-font-style';
$mod = get_theme_mod( $setting, customizer_library_get_default( $setting ) );

if ( $mod !== customizer_library_get_default( $setting ) ) {

	$text = customizer_library_sanitize_text( $mod );

	Customizer_Library_Styles()->add( array(
		'selectors' => array(
			'h1, h2, h3, h4, h5, h6'
		),
		'declarations' => array(
			'font-style' => $text
		)
	) );
}

// Text Transform
$setting = 'type-header-text-transform';
$mod = get_theme_mod( $setting, customizer_library_get_default( $setting ) );

if ( $mod !== customizer_library_get_default( $setting ) ) {

	$text = customizer_library_sanitize_text( $mod );

	Customizer_Library_Styles()->add( array(
		'selectors' => array(
			'h1, h2, h3, h4, h5, h6'
		),
		'declarations' => array(
			'text-transform' => $text
		)
	) );
}

// Line Height
$setting = 'type-header-line-height';
$mod = get_theme_mod( $setting, customizer_library_get_default( $setting ) );

if ( $mod !== customizer_library_get_default( $setting ) ) {

	$text = customizer_library_sanitize_text( $mod );

	Customizer_Library_Styles()->add( array(
		'selectors' => array(
			'h1, h2, h3, h4, h5, h6'
		),
		'declarations' => array(
			'line-height' => $text
		)
	) );
}

// Letter Spacing
$setting = 'type-header-letter-spacing';
$mod = get_theme_mod( $setting, customizer_library_get_default( $setting ) );

if ( $mod !== customizer_library_get_default( $setting ) ) {

	$text = customizer_library_sanitize_text( $mod );

	Customizer_Library_Styles()->add( array(
		'selectors' => array(
			'h1, h2, h3, h4, h5, h6'
		),
		'declarations' => array(
			'letter-spacing' => $text
		)
	) );
}

// Word Spacing
$setting = 'type-header-word-spacing';
$mod = get_theme_mod( $setting, customizer_library_get_default( $setting ) );

if ( $mod !== customizer_library_get_default( $setting ) ) {

	$text = customizer_library_sanitize_text( $mod );

	Customizer_Library_Styles()->add( array(
		'selectors' => array(
			'h1, h2, h3, h4, h5, h6'
		),
		'declarations' => array(
			'word-spacing' => $text
		)
	) );
}

/*--------------------------------------------------------------
 5.3 Typography: Site Title & Tagline
--------------------------------------------------------------*/
/* Site Tagline */
// Font Family
$setting = 'type-sitetitle-font-family';
$mod = get_theme_mod( $setting, customizer_library_get_default( $setting ) );

$stack = customizer_library_get_font_stack( $mod );

if ( $mod != customizer_library_get_default( $setting ) ) {

	Customizer_Library_Styles()->add( array(
		'selectors' => array(
			'.site-header .site-branding h1.site-title'
		),
		'declarations' => array(
			'font-family' => $stack
		)
	) );

}

// Font Size
$setting = 'type-sitetitle-font-size';
$mod = get_theme_mod( $setting, customizer_library_get_default( $setting ) );

if ( $mod !== customizer_library_get_default( $setting ) ) {

	$text = customizer_library_sanitize_text( $mod );

	Customizer_Library_Styles()->add( array(
		'selectors' => array(
			'.site-header .site-branding h1.site-title'
		),
		'declarations' => array(
			'font-size' => $text
		)
	) );
}

// Font Weight
$setting = 'type-sitetitle-font-weight';
$mod = get_theme_mod( $setting, customizer_library_get_default( $setting ) );

if ( $mod !== customizer_library_get_default( $setting ) ) {

	$text = customizer_library_sanitize_text( $mod );

	Customizer_Library_Styles()->add( array(
		'selectors' => array(
			'.site-header .site-branding h1.site-title'
		),
		'declarations' => array(
			'font-weight' => $text
		)
	) );
}

// Font Style
$setting = 'type-sitetitle-font-style';
$mod = get_theme_mod( $setting, customizer_library_get_default( $setting ) );

if ( $mod !== customizer_library_get_default( $setting ) ) {

	$text = customizer_library_sanitize_text( $mod );

	Customizer_Library_Styles()->add( array(
		'selectors' => array(
			'.site-header .site-branding h1.site-title'
		),
		'declarations' => array(
			'font-style' => $text
		)
	) );
}

// Text Transform
$setting = 'type-sitetitle-text-transform';
$mod = get_theme_mod( $setting, customizer_library_get_default( $setting ) );

if ( $mod !== customizer_library_get_default( $setting ) ) {

	$text = customizer_library_sanitize_text( $mod );

	Customizer_Library_Styles()->add( array(
		'selectors' => array(
			'.site-header .site-branding h1.site-title'
		),
		'declarations' => array(
			'text-transform' => $text
		)
	) );
}

// Line Height
$setting = 'type-sitetitle-line-height';
$mod = get_theme_mod( $setting, customizer_library_get_default( $setting ) );

if ( $mod !== customizer_library_get_default( $setting ) ) {

	$text = customizer_library_sanitize_text( $mod );

	Customizer_Library_Styles()->add( array(
		'selectors' => array(
			'.site-header .site-branding h1.site-title'
		),
		'declarations' => array(
			'line-height' => $text
		)
	) );
}

// Letter Spacing
$setting = 'type-sitetitle-letter-spacing';
$mod = get_theme_mod( $setting, customizer_library_get_default( $setting ) );

if ( $mod !== customizer_library_get_default( $setting ) ) {

	$text = customizer_library_sanitize_text( $mod );

	Customizer_Library_Styles()->add( array(
		'selectors' => array(
			'.site-header .site-branding h1.site-title'
		),
		'declarations' => array(
			'letter-spacing' => $text
		)
	) );
}

// Word Spacing
$setting = 'type-sitetitle-word-spacing';
$mod = get_theme_mod( $setting, customizer_library_get_default( $setting ) );

if ( $mod !== customizer_library_get_default( $setting ) ) {

	$text = customizer_library_sanitize_text( $mod );

	Customizer_Library_Styles()->add( array(
		'selectors' => array(
			'.site-header .site-branding h1.site-title'
		),
		'declarations' => array(
			'word-spacing' => $text
		)
	) );
}

/* Site Tagline */
// Font Family
$setting = 'type-sitetagline-font-family';
$mod = get_theme_mod( $setting, customizer_library_get_default( $setting ) );

$stack = customizer_library_get_font_stack( $mod );

if ( $mod != customizer_library_get_default( $setting ) ) {

	Customizer_Library_Styles()->add( array(
		'selectors' => array(
			'.site-header .site-branding p.site-description'
		),
		'declarations' => array(
			'font-family' => $stack
		)
	) );

}

// Font Size
$setting = 'type-sitetagline-font-size';
$mod = get_theme_mod( $setting, customizer_library_get_default( $setting ) );

if ( $mod !== customizer_library_get_default( $setting ) ) {

	$text = customizer_library_sanitize_text( $mod );

	Customizer_Library_Styles()->add( array(
		'selectors' => array(
			'.site-header .site-branding p.site-description'
		),
		'declarations' => array(
			'font-size' => $text
		)
	) );
}

// Font Weight
$setting = 'type-sitetagline-font-weight';
$mod = get_theme_mod( $setting, customizer_library_get_default( $setting ) );

if ( $mod !== customizer_library_get_default( $setting ) ) {

	$text = customizer_library_sanitize_text( $mod );

	Customizer_Library_Styles()->add( array(
		'selectors' => array(
			'.site-header .site-branding p.site-description'
		),
		'declarations' => array(
			'font-weight' => $text
		)
	) );
}

// Font Style
$setting = 'type-sitetagline-font-style';
$mod = get_theme_mod( $setting, customizer_library_get_default( $setting ) );

if ( $mod !== customizer_library_get_default( $setting ) ) {

	$text = customizer_library_sanitize_text( $mod );

	Customizer_Library_Styles()->add( array(
		'selectors' => array(
			'.site-header .site-branding p.site-description'
		),
		'declarations' => array(
			'font-style' => $text
		)
	) );
}

// Text Transform
$setting = 'type-sitetagline-text-transform';
$mod = get_theme_mod( $setting, customizer_library_get_default( $setting ) );

if ( $mod !== customizer_library_get_default( $setting ) ) {

	$text = customizer_library_sanitize_text( $mod );

	Customizer_Library_Styles()->add( array(
		'selectors' => array(
			'.site-header .site-branding p.site-description'
		),
		'declarations' => array(
			'text-transform' => $text
		)
	) );
}

// Line Height
$setting = 'type-sitetagline-line-height';
$mod = get_theme_mod( $setting, customizer_library_get_default( $setting ) );

if ( $mod !== customizer_library_get_default( $setting ) ) {

	$text = customizer_library_sanitize_text( $mod );

	Customizer_Library_Styles()->add( array(
		'selectors' => array(
			'.site-header .site-branding p.site-description'
		),
		'declarations' => array(
			'line-height' => $text
		)
	) );
}

// Letter Spacing
$setting = 'type-sitetagline-letter-spacing';
$mod = get_theme_mod( $setting, customizer_library_get_default( $setting ) );

if ( $mod !== customizer_library_get_default( $setting ) ) {

	$text = customizer_library_sanitize_text( $mod );

	Customizer_Library_Styles()->add( array(
		'selectors' => array(
			'.site-header .site-branding p.site-description'
		),
		'declarations' => array(
			'letter-spacing' => $text
		)
	) );
}

// Word Spacing
$setting = 'type-sitetagline-word-spacing';
$mod = get_theme_mod( $setting, customizer_library_get_default( $setting ) );

if ( $mod !== customizer_library_get_default( $setting ) ) {

	$text = customizer_library_sanitize_text( $mod );

	Customizer_Library_Styles()->add( array(
		'selectors' => array(
			'.site-header .site-branding p.site-description'
		),
		'declarations' => array(
			'word-spacing' => $text
		)
	) );
}

/*--------------------------------------------------------------
 5.4 Typography: Navigation
--------------------------------------------------------------*/

// Font Family
$setting = 'type-main-menu-font-family';
$mod = get_theme_mod( $setting, customizer_library_get_default( $setting ) );

$stack = customizer_library_get_font_stack( $mod );

if ( $mod != customizer_library_get_default( $setting ) ) {

	Customizer_Library_Styles()->add( array(
		'selectors' => array(
			'#site-navigation li a'
		),
		'declarations' => array(
			'font-family' => $stack
		)
	) );

}

// Font Size
$setting = 'type-main-menu-font-size';
$mod = get_theme_mod( $setting, customizer_library_get_default( $setting ) );

if ( $mod !== customizer_library_get_default( $setting ) ) {

	$text = customizer_library_sanitize_text( $mod );

	Customizer_Library_Styles()->add( array(
		'selectors' => array(
			'#site-navigation li a'
		),
		'declarations' => array(
			'font-size' => $text
		)
	) );
}

// Font Weight
$setting = 'type-main-menu-font-weight';
$mod = get_theme_mod( $setting, customizer_library_get_default( $setting ) );

if ( $mod !== customizer_library_get_default( $setting ) ) {

	$text = customizer_library_sanitize_text( $mod );

	Customizer_Library_Styles()->add( array(
		'selectors' => array(
			'#site-navigation li:not(.has-form) a:not(.button)'
		),
		'declarations' => array(
			'font-weight' => $text
		)
	) );
}

// Font Style
$setting = 'type-main-menu-font-style';
$mod = get_theme_mod( $setting, customizer_library_get_default( $setting ) );

if ( $mod !== customizer_library_get_default( $setting ) ) {

	$text = customizer_library_sanitize_text( $mod );

	Customizer_Library_Styles()->add( array(
		'selectors' => array(
			'#site-navigation li a'
		),
		'declarations' => array(
			'font-style' => $text
		)
	) );
}

// Text Transform
$setting = 'type-main-menu-text-transform';
$mod = get_theme_mod( $setting, customizer_library_get_default( $setting ) );

if ( $mod !== customizer_library_get_default( $setting ) ) {

	$text = customizer_library_sanitize_text( $mod );

	Customizer_Library_Styles()->add( array(
		'selectors' => array(
			'#site-navigation li a'
		),
		'declarations' => array(
			'text-transform' => $text
		)
	) );
}

// Line Height
$setting = 'type-main-menu-line-height';
$mod = get_theme_mod( $setting, customizer_library_get_default( $setting ) );

if ( $mod !== customizer_library_get_default( $setting ) ) {

	$text = customizer_library_sanitize_text( $mod );

	Customizer_Library_Styles()->add( array(
		'selectors' => array(
			'#site-navigation .sub-menu li:not(.has-form):not(.active) > a:not(.button)'
		),
		'declarations' => array(
			'line-height' => $text
		)
	) );
}

// Letter Spacing
$setting = 'type-main-menu-letter-spacing';
$mod = get_theme_mod( $setting, customizer_library_get_default( $setting ) );

if ( $mod !== customizer_library_get_default( $setting ) ) {

	$text = customizer_library_sanitize_text( $mod );

	Customizer_Library_Styles()->add( array(
		'selectors' => array(
			'#site-navigation li a'
		),
		'declarations' => array(
			'letter-spacing' => $text
		)
	) );
}

// Word Spacing
$setting = 'type-main-menu-word-spacing';
$mod = get_theme_mod( $setting, customizer_library_get_default( $setting ) );

if ( $mod !== customizer_library_get_default( $setting ) ) {

	$text = customizer_library_sanitize_text( $mod );

	Customizer_Library_Styles()->add( array(
		'selectors' => array(
			'#site-navigation li a'
		),
		'declarations' => array(
			'word-spacing' => $text
		)
	) );
}

/*--------------------------------------------------------------
 5.5 Typography: Sidebar
--------------------------------------------------------------*/
// Font Family
$setting = 'type-widget-title-font-family';
$mod = get_theme_mod( $setting, customizer_library_get_default( $setting ) );

$stack = customizer_library_get_font_stack( $mod );

if ( $mod != customizer_library_get_default( $setting ) ) {

	Customizer_Library_Styles()->add( array(
		'selectors' => array(
			'.inner-sidebar h2.widget-title'
		),
		'declarations' => array(
			'font-family' => $stack
		)
	) );

}

// Font Size
$setting = 'type-widget-title-font-size';
$mod = get_theme_mod( $setting, customizer_library_get_default( $setting ) );

if ( $mod !== customizer_library_get_default( $setting ) ) {

	$text = customizer_library_sanitize_text( $mod );

	Customizer_Library_Styles()->add( array(
		'selectors' => array(
			'.inner-sidebar h2.widget-title'
		),
		'declarations' => array(
			'font-size' => $text
		)
	) );
}

// Font Weight
$setting = 'type-widget-title-font-weight';
$mod = get_theme_mod( $setting, customizer_library_get_default( $setting ) );

if ( $mod !== customizer_library_get_default( $setting ) ) {

	$text = customizer_library_sanitize_text( $mod );

	Customizer_Library_Styles()->add( array(
		'selectors' => array(
			'.inner-sidebar h2.widget-title'
		),
		'declarations' => array(
			'font-weight' => $text
		)
	) );
}

// Font Style
$setting = 'type-widget-title-font-style';
$mod = get_theme_mod( $setting, customizer_library_get_default( $setting ) );

if ( $mod !== customizer_library_get_default( $setting ) ) {

	$text = customizer_library_sanitize_text( $mod );

	Customizer_Library_Styles()->add( array(
		'selectors' => array(
			'.inner-sidebar h2.widget-title'
		),
		'declarations' => array(
			'font-style' => $text
		)
	) );
}

// Text Transform
$setting = 'type-widget-title-text-transform';
$mod = get_theme_mod( $setting, customizer_library_get_default( $setting ) );

if ( $mod !== customizer_library_get_default( $setting ) ) {

	$text = customizer_library_sanitize_text( $mod );

	Customizer_Library_Styles()->add( array(
		'selectors' => array(
			'.inner-sidebar h2.widget-title'
		),
		'declarations' => array(
			'text-transform' => $text
		)
	) );
}

// Line Height
$setting = 'type-widget-title-line-height';
$mod = get_theme_mod( $setting, customizer_library_get_default( $setting ) );

if ( $mod !== customizer_library_get_default( $setting ) ) {

	$text = customizer_library_sanitize_text( $mod );

	Customizer_Library_Styles()->add( array(
		'selectors' => array(
			'.inner-sidebar h2.widget-title'
		),
		'declarations' => array(
			'line-height' => $text
		)
	) );
}

// Letter Spacing
$setting = 'type-widget-title-letter-spacing';
$mod = get_theme_mod( $setting, customizer_library_get_default( $setting ) );

if ( $mod !== customizer_library_get_default( $setting ) ) {

	$text = customizer_library_sanitize_text( $mod );

	Customizer_Library_Styles()->add( array(
		'selectors' => array(
			'.inner-sidebar h2.widget-title'
		),
		'declarations' => array(
			'letter-spacing' => $text
		)
	) );
}

// Word Spacing
$setting = 'type-widget-title-word-spacing';
$mod = get_theme_mod( $setting, customizer_library_get_default( $setting ) );

if ( $mod !== customizer_library_get_default( $setting ) ) {

	$text = customizer_library_sanitize_text( $mod );

	Customizer_Library_Styles()->add( array(
		'selectors' => array(
			'.inner-sidebar h2.widget-title'
		),
		'declarations' => array(
			'word-spacing' => $text
		)
	) );
}

/* Sidebar Body */
// Font Family
$setting = 'type-widget-body-font-family';
$mod = get_theme_mod( $setting, customizer_library_get_default( $setting ) );

$stack = customizer_library_get_font_stack( $mod );

if ( $mod != customizer_library_get_default( $setting ) ) {

	Customizer_Library_Styles()->add( array(
		'selectors' => array(
			'.widget-area aside, .widget-area aside ul, .widget-area aside li, .widget-area aside p'
		),
		'declarations' => array(
			'font-family' => $stack
		)
	) );

}

// Font Size
$setting = 'type-widget-body-font-size';
$mod = get_theme_mod( $setting, customizer_library_get_default( $setting ) );

if ( $mod !== customizer_library_get_default( $setting ) ) {

	$text = customizer_library_sanitize_text( $mod );

	Customizer_Library_Styles()->add( array(
		'selectors' => array(
			'.widget-area aside, .widget-area aside ul, .widget-area aside li, .widget-area aside p ul, .widget-area aside, .widget-area aside ul, .widget-area aside li, .widget-area aside p li, .widget-area aside, .widget-area aside ul, .widget-area aside li, .widget-area aside p p'
		),
		'declarations' => array(
			'font-size' => $text
		)
	) );
}

// Font Weight
$setting = 'type-widget-body-font-weight';
$mod = get_theme_mod( $setting, customizer_library_get_default( $setting ) );

if ( $mod !== customizer_library_get_default( $setting ) ) {

	$text = customizer_library_sanitize_text( $mod );

	Customizer_Library_Styles()->add( array(
		'selectors' => array(
			'.widget-area aside, .widget-area aside ul, .widget-area aside li, .widget-area aside p'
		),
		'declarations' => array(
			'font-weight' => $text
		)
	) );
}

// Font Style
$setting = 'type-widget-body-font-style';
$mod = get_theme_mod( $setting, customizer_library_get_default( $setting ) );

if ( $mod !== customizer_library_get_default( $setting ) ) {

	$text = customizer_library_sanitize_text( $mod );

	Customizer_Library_Styles()->add( array(
		'selectors' => array(
			'.widget-area aside, .widget-area aside ul, .widget-area aside li, .widget-area aside p'
		),
		'declarations' => array(
			'font-style' => $text
		)
	) );
}

// Text Transform
$setting = 'type-widget-body-text-transform';
$mod = get_theme_mod( $setting, customizer_library_get_default( $setting ) );

if ( $mod !== customizer_library_get_default( $setting ) ) {

	$text = customizer_library_sanitize_text( $mod );

	Customizer_Library_Styles()->add( array(
		'selectors' => array(
			'.widget-area aside, .widget-area aside ul, .widget-area aside li, .widget-area aside p'
		),
		'declarations' => array(
			'text-transform' => $text
		)
	) );
}

// Line Height
$setting = 'type-widget-body-line-height';
$mod = get_theme_mod( $setting, customizer_library_get_default( $setting ) );

if ( $mod !== customizer_library_get_default( $setting ) ) {

	$text = customizer_library_sanitize_text( $mod );

	Customizer_Library_Styles()->add( array(
		'selectors' => array(
			'.widget-area aside, .widget-area aside ul, .widget-area aside li, .widget-area aside p'
		),
		'declarations' => array(
			'line-height' => $text
		)
	) );
}

// Letter Spacing
$setting = 'type-widget-body-letter-spacing';
$mod = get_theme_mod( $setting, customizer_library_get_default( $setting ) );

if ( $mod !== customizer_library_get_default( $setting ) ) {

	$text = customizer_library_sanitize_text( $mod );

	Customizer_Library_Styles()->add( array(
		'selectors' => array(
			'.widget-area aside, .widget-area aside ul, .widget-area aside li, .widget-area aside p'
		),
		'declarations' => array(
			'letter-spacing' => $text
		)
	) );
}

// Word Spacing
$setting = 'type-widget-body-word-spacing';
$mod = get_theme_mod( $setting, customizer_library_get_default( $setting ) );

if ( $mod !== customizer_library_get_default( $setting ) ) {

	$text = customizer_library_sanitize_text( $mod );

	Customizer_Library_Styles()->add( array(
		'selectors' => array(
			'.widget-area aside, .widget-area aside ul, .widget-area aside li, .widget-area aside p'
		),
		'declarations' => array(
			'word-spacing' => $text
		)
	) );
}

/*--------------------------------------------------------------
5.6 Typography: Footer
--------------------------------------------------------------*/
/*-- Widget Title --*/
	// Font Family
	$setting = 'type-footer-widget-title-font-family';
	$mod = get_theme_mod( $setting, customizer_library_get_default( $setting ) );

	$stack = customizer_library_get_font_stack( $mod );

	if ( $mod != customizer_library_get_default( $setting ) ) {

		Customizer_Library_Styles()->add( array(
			'selectors' => array(
				'.footer-wrap .widget-title'
			),
			'declarations' => array(
				'font-family' => $stack
			)
		) );

	}

	// Font Size
	$setting = 'type-footer-widget-title-font-size';
	$mod = get_theme_mod( $setting, customizer_library_get_default( $setting ) );

	if ( $mod !== customizer_library_get_default( $setting ) ) {

		$text = customizer_library_sanitize_text( $mod );

		Customizer_Library_Styles()->add( array(
			'selectors' => array(
				'.footer-wrap .widget-title'
			),
			'declarations' => array(
				'font-size' => $text
			)
		) );
	}

	// Font Weight
	$setting = 'type-footer-widget-title-font-weight';
	$mod = get_theme_mod( $setting, customizer_library_get_default( $setting ) );

	if ( $mod !== customizer_library_get_default( $setting ) ) {

		$text = customizer_library_sanitize_text( $mod );

		Customizer_Library_Styles()->add( array(
			'selectors' => array(
				'.footer-wrap .widget-title'
			),
			'declarations' => array(
				'font-weight' => $text
			)
		) );
	}

	// Font Style
	$setting = 'type-footer-widget-title-font-style';
	$mod = get_theme_mod( $setting, customizer_library_get_default( $setting ) );

	if ( $mod !== customizer_library_get_default( $setting ) ) {

		$text = customizer_library_sanitize_text( $mod );

		Customizer_Library_Styles()->add( array(
			'selectors' => array(
				'.footer-wrap .widget-title'
			),
			'declarations' => array(
				'font-style' => $text
			)
		) );
	}

	// Text Transform
	$setting = 'type-footer-widget-title-text-transform';
	$mod = get_theme_mod( $setting, customizer_library_get_default( $setting ) );

	if ( $mod !== customizer_library_get_default( $setting ) ) {

		$text = customizer_library_sanitize_text( $mod );

		Customizer_Library_Styles()->add( array(
			'selectors' => array(
				'.footer-wrap .widget-title'
			),
			'declarations' => array(
				'text-transform' => $text
			)
		) );
	}

	// Line Height
	$setting = 'type-footer-widget-title-line-height';
	$mod = get_theme_mod( $setting, customizer_library_get_default( $setting ) );

	if ( $mod !== customizer_library_get_default( $setting ) ) {

		$text = customizer_library_sanitize_text( $mod );

		Customizer_Library_Styles()->add( array(
			'selectors' => array(
				'.footer-wrap .widget-title'
			),
			'declarations' => array(
				'line-height' => $text
			)
		) );
	}

	// Letter Spacing
	$setting = 'type-footer-widget-title-letter-spacing';
	$mod = get_theme_mod( $setting, customizer_library_get_default( $setting ) );

	if ( $mod !== customizer_library_get_default( $setting ) ) {

		$text = customizer_library_sanitize_text( $mod );

		Customizer_Library_Styles()->add( array(
			'selectors' => array(
				'.footer-wrap .widget-title'
			),
			'declarations' => array(
				'letter-spacing' => $text
			)
		) );
	}

	// Word Spacing
	$setting = 'type-footer-widget-title-word-spacing';
	$mod = get_theme_mod( $setting, customizer_library_get_default( $setting ) );

	if ( $mod !== customizer_library_get_default( $setting ) ) {

		$text = customizer_library_sanitize_text( $mod );

		Customizer_Library_Styles()->add( array(
			'selectors' => array(
				'.footer-wrap .widget-title'
			),
			'declarations' => array(
				'word-spacing' => $text
			)
		) );
	}

/*-- Footer Widget Body --*/
	// Font Family
	$setting = 'type-footer-widget-body-font-family';
	$mod = get_theme_mod( $setting, customizer_library_get_default( $setting ) );

	$stack = customizer_library_get_font_stack( $mod );

	if ( $mod != customizer_library_get_default( $setting ) ) {

		Customizer_Library_Styles()->add( array(
			'selectors' => array(
				'.site-footer aside ul, .site-footer aside li, .site-footer aside p, .site-footer aside .textwidget'
			),
			'declarations' => array(
				'font-family' => $stack
			)
		) );

	}

	// Font Size
	$setting = 'type-footer-widget-body-font-size';
	$mod = get_theme_mod( $setting, customizer_library_get_default( $setting ) );

	if ( $mod !== customizer_library_get_default( $setting ) ) {

		$text = customizer_library_sanitize_text( $mod );

		Customizer_Library_Styles()->add( array(
			'selectors' => array(
				'.site-footer aside ul, .site-footer aside li, .site-footer aside p, .site-footer aside .textwidget'
			),
			'declarations' => array(
				'font-size' => $text
			)
		) );
	}

	// Font Weight
	$setting = 'type-footer-widget-body-font-weight';
	$mod = get_theme_mod( $setting, customizer_library_get_default( $setting ) );

	if ( $mod !== customizer_library_get_default( $setting ) ) {

		$text = customizer_library_sanitize_text( $mod );

		Customizer_Library_Styles()->add( array(
			'selectors' => array(
				'.site-footer aside ul, .site-footer aside li, .site-footer aside p, .site-footer aside .textwidget'
			),
			'declarations' => array(
				'font-weight' => $text
			)
		) );
	}

	// Font Style
	$setting = 'type-footer-widget-body-font-style';
	$mod = get_theme_mod( $setting, customizer_library_get_default( $setting ) );

	if ( $mod !== customizer_library_get_default( $setting ) ) {

		$text = customizer_library_sanitize_text( $mod );

		Customizer_Library_Styles()->add( array(
			'selectors' => array(
				'.site-footer aside ul, .site-footer aside li, .site-footer aside p, .site-footer aside .textwidget'
			),
			'declarations' => array(
				'font-style' => $text
			)
		) );
	}

	// Text Transform
	$setting = 'type-footer-widget-body-text-transform';
	$mod = get_theme_mod( $setting, customizer_library_get_default( $setting ) );

	if ( $mod !== customizer_library_get_default( $setting ) ) {

		$text = customizer_library_sanitize_text( $mod );

		Customizer_Library_Styles()->add( array(
			'selectors' => array(
				'.site-footer aside ul, .site-footer aside li, .site-footer aside p, .site-footer aside .textwidget'
			),
			'declarations' => array(
				'text-transform' => $text
			)
		) );
	}

	// Line Height
	$setting = 'type-footer-widget-body-line-height';
	$mod = get_theme_mod( $setting, customizer_library_get_default( $setting ) );

	if ( $mod !== customizer_library_get_default( $setting ) ) {

		$text = customizer_library_sanitize_text( $mod );

		Customizer_Library_Styles()->add( array(
			'selectors' => array(
				'.site-footer aside ul, .site-footer aside li, .site-footer aside p, .site-footer aside .textwidget'
			),
			'declarations' => array(
				'line-height' => $text
			)
		) );
	}

	// Letter Spacing
	$setting = 'type-footer-widget-body-letter-spacing';
	$mod = get_theme_mod( $setting, customizer_library_get_default( $setting ) );

	if ( $mod !== customizer_library_get_default( $setting ) ) {

		$text = customizer_library_sanitize_text( $mod );

		Customizer_Library_Styles()->add( array(
			'selectors' => array(
				'.site-footer aside ul, .site-footer aside li, .site-footer aside p, .site-footer aside .textwidget'
			),
			'declarations' => array(
				'letter-spacing' => $text
			)
		) );
	}

	// Word Spacing
	$setting = 'type-footer-widget-body-word-spacing';
	$mod = get_theme_mod( $setting, customizer_library_get_default( $setting ) );

	if ( $mod !== customizer_library_get_default( $setting ) ) {

		$text = customizer_library_sanitize_text( $mod );

		Customizer_Library_Styles()->add( array(
			'selectors' => array(
				'.site-footer aside ul, .site-footer aside li, .site-footer aside p, .site-footer aside .textwidget'
			),
			'declarations' => array(
				'word-spacing' => $text
			)
		) );
	}

/*--------------------------------------------------------------
5.7 Typography: Copyright
--------------------------------------------------------------*/
	// Font Family
	$setting = 'type-copyright-font-family';
	$mod = get_theme_mod( $setting, customizer_library_get_default( $setting ) );

	$stack = customizer_library_get_font_stack( $mod );

	if ( $mod != customizer_library_get_default( $setting ) ) {

		Customizer_Library_Styles()->add( array(
			'selectors' => array(
				'.copyright-info, .copyright-info p, .copyright-info a'
			),
			'declarations' => array(
				'font-family' => $stack
			)
		) );

	}

	// Font Size
	$setting = 'type-copyright-font-size';
	$mod = get_theme_mod( $setting, customizer_library_get_default( $setting ) );

	if ( $mod !== customizer_library_get_default( $setting ) ) {

		$text = customizer_library_sanitize_text( $mod );

		Customizer_Library_Styles()->add( array(
			'selectors' => array(
				'.copyright-info, .copyright-info p, .copyright-info a'
			),
			'declarations' => array(
				'font-size' => $text
			)
		) );
	}

	// Font Weight
	$setting = 'type-copyright-font-weight';
	$mod = get_theme_mod( $setting, customizer_library_get_default( $setting ) );

	if ( $mod !== customizer_library_get_default( $setting ) ) {

		$text = customizer_library_sanitize_text( $mod );

		Customizer_Library_Styles()->add( array(
			'selectors' => array(
				'.copyright-info, .copyright-info p, .copyright-info a'
			),
			'declarations' => array(
				'font-weight' => $text
			)
		) );
	}

	// Font Style
	$setting = 'type-copyright-font-style';
	$mod = get_theme_mod( $setting, customizer_library_get_default( $setting ) );

	if ( $mod !== customizer_library_get_default( $setting ) ) {

		$text = customizer_library_sanitize_text( $mod );

		Customizer_Library_Styles()->add( array(
			'selectors' => array(
				'.copyright-info, .copyright-info p, .copyright-info a'
			),
			'declarations' => array(
				'font-style' => $text
			)
		) );
	}

	// Text Transform
	$setting = 'type-copyright-text-transform';
	$mod = get_theme_mod( $setting, customizer_library_get_default( $setting ) );

	if ( $mod !== customizer_library_get_default( $setting ) ) {

		$text = customizer_library_sanitize_text( $mod );

		Customizer_Library_Styles()->add( array(
			'selectors' => array(
				'.copyright-info, .copyright-info p, .copyright-info a'
			),
			'declarations' => array(
				'text-transform' => $text
			)
		) );
	}

	// Line Height
	$setting = 'type-copyright-line-height';
	$mod = get_theme_mod( $setting, customizer_library_get_default( $setting ) );

	if ( $mod !== customizer_library_get_default( $setting ) ) {

		$text = customizer_library_sanitize_text( $mod );

		Customizer_Library_Styles()->add( array(
			'selectors' => array(
				'.copyright-info, .copyright-info p, .copyright-info a'
			),
			'declarations' => array(
				'line-height' => $text
			)
		) );
	}

	// Letter Spacing
	$setting = 'type-copyright-letter-spacing';
	$mod = get_theme_mod( $setting, customizer_library_get_default( $setting ) );

	if ( $mod !== customizer_library_get_default( $setting ) ) {

		$text = customizer_library_sanitize_text( $mod );

		Customizer_Library_Styles()->add( array(
			'selectors' => array(
				'.copyright-info, .copyright-info p, .copyright-info a'
			),
			'declarations' => array(
				'letter-spacing' => $text
			)
		) );
	}

	// Word Spacing
	$setting = 'type-copyright-word-spacing';
	$mod = get_theme_mod( $setting, customizer_library_get_default( $setting ) );

	if ( $mod !== customizer_library_get_default( $setting ) ) {

		$text = customizer_library_sanitize_text( $mod );

		Customizer_Library_Styles()->add( array(
			'selectors' => array(
				'.copyright-info, .copyright-info p, .copyright-info a'
			),
			'declarations' => array(
				'word-spacing' => $text
			)
		) );
	}

/*--------------------------------------------------------------
6.1 Colors: Sitewide
--------------------------------------------------------------*/
	// Color: Headers
	$setting = 'color-headers';
	$mod = get_theme_mod( $setting, customizer_library_get_default( $setting ) );

	if ( $mod !== customizer_library_get_default( $setting ) ) {

		$color = sanitize_hex_color( $mod );

		Customizer_Library_Styles()->add( array(
			'selectors' => array(
				'.content-area h1, .content-area h2, .content-area h3, .content-area h4, .content-area h5, .content-area h6, .page-header h1'
			),
			'declarations' => array(
				'color' => $color
			)
		) );
	}

	// Color: Content
	$setting = 'color-content';
	$mod = get_theme_mod( $setting, customizer_library_get_default( $setting ) );

	if ( $mod !== customizer_library_get_default( $setting ) ) {

		$color = sanitize_hex_color( $mod );

		Customizer_Library_Styles()->add( array(
			'selectors' => array(
				'.entry-content p, .comment_content p, .home-secondary-content p'
			),
			'declarations' => array(
				'color' => $color
			)
		) );
	}

	// Color: Links
	$setting = 'color-content-link';
	$mod = get_theme_mod( $setting, customizer_library_get_default( $setting ) );

	if ( $mod !== customizer_library_get_default( $setting ) ) {

		$color = sanitize_hex_color( $mod );

		Customizer_Library_Styles()->add( array(
			'selectors' => array(
				'#content a, .hero-widgets-wrap a'
			),
			'declarations' => array(
				'color' => $color
			)
		) );
	}

	// Color: Link Hover
	$setting = 'color-content-link-hover';
	$mod = get_theme_mod( $setting, customizer_library_get_default( $setting ) );

	if ( $mod !== customizer_library_get_default( $setting ) ) {

		$color = sanitize_hex_color( $mod );

		Customizer_Library_Styles()->add( array(
			'selectors' => array(
				'#content a:hover, .comment_content a:hover, .hero-widgets-wrap a:hover'
			),
			'declarations' => array(
				'color' => $color
			)
		) );
	}

	// Color: Top Mini Bar
	$setting = 'color-content-top-bar';
	$mod = get_theme_mod( $setting, customizer_library_get_default( $setting ) );

	if ( $mod !== customizer_library_get_default( $setting ) ) {

		$color = sanitize_hex_color( $mod );

		Customizer_Library_Styles()->add( array(
			'selectors' => array(
				'.mini-header'
			),
			'declarations' => array(
				'background-color' => $color
			)
		) );
	}

	// Color: Body Background
	$setting = 'color-content-body-bg';
	$mod = get_theme_mod( $setting, customizer_library_get_default( $setting ) );

	if ( $mod !== customizer_library_get_default( $setting ) ) {

		$color = sanitize_hex_color( $mod );

		Customizer_Library_Styles()->add( array(
			'selectors' => array(
				'body, .home .content-area'
			),
			'declarations' => array(
				'background-color' => $color
			)
		) );
	}

	// Color: Content Background
	$setting = 'color-content-bg';
	$mod = get_theme_mod( $setting, customizer_library_get_default( $setting ) );

	if ( $mod !== customizer_library_get_default( $setting ) ) {

		$color = sanitize_hex_color( $mod );

		Customizer_Library_Styles()->add( array(
			'selectors' => array(
				'#page .site-content .row'
			),
			'declarations' => array(
				'background-color' => $color
			)
		) );
	}

	// Color: Comments Background
	$setting = 'color-comments-bg';
	$mod = get_theme_mod( $setting, customizer_library_get_default( $setting ) );

	if ( $mod !== customizer_library_get_default( $setting ) ) {

		$color = sanitize_hex_color( $mod );

		Customizer_Library_Styles()->add( array(
			'selectors' => array(
				'#comments ol.comment-list .comment-content-wrap'
			),
			'declarations' => array(
				'background-color' => $color
			)
		) );
	}

/*--------------------------------------------------------------
6.2 Colors: Navigation
--------------------------------------------------------------*/
	// Color: Nav BG
	$setting = 'nav-bg';
	$mod = get_theme_mod( $setting, customizer_library_get_default( $setting ) );

	if ( $mod !== customizer_library_get_default( $setting ) ) {

		$color = sanitize_hex_color( $mod );

		Customizer_Library_Styles()->add( array(
			'selectors' => array(
				'header#masthead, header#masthead.stick, #site-navigation li, .mini-header-wrap'
			),
			'declarations' => array(
				'background-color' => $color
			)
		) );
	}

	// Color: Nav BG Hover
	$setting = 'nav-bg-hover';
	$mod = get_theme_mod( $setting, customizer_library_get_default( $setting ) );

	if ( $mod !== customizer_library_get_default( $setting ) ) {

		$color = sanitize_hex_color( $mod );

		Customizer_Library_Styles()->add( array(
			'selectors' => array(
				'#site-navigation li:hover, #site-navigation ul li ul.sub-menu, #site-navigation ul li ul.sub-menu li'
			),
			'declarations' => array(
				'background-color' => $color
			)
		) );
	}

	// Color: Nav Links
	$setting = 'nav-links';
	$mod = get_theme_mod( $setting, customizer_library_get_default( $setting ) );

	if ( $mod !== customizer_library_get_default( $setting ) ) {

		$color = sanitize_hex_color( $mod );

		Customizer_Library_Styles()->add( array(
			'selectors' => array(
				'#site-navigation li a'
			),
			'declarations' => array(
				'color' => $color
			)
		) );
	}

	// Color: Nav Links Hover
	$setting = 'nav-links-hover';
	$mod = get_theme_mod( $setting, customizer_library_get_default( $setting ) );

	if ( $mod !== customizer_library_get_default( $setting ) ) {

		$color = sanitize_hex_color( $mod );

		Customizer_Library_Styles()->add( array(
			'selectors' => array(
				'#site-navigation li:hover > a, #site-navigation ul li ul.sub-menu li a:hover'
			),
			'declarations' => array(
				'color' => $color
			)
		) );
	}

/*--------------------------------------------------------------
6.3 Colors: Title & Tagline
--------------------------------------------------------------*/
	// Color: Title
	$setting = 'color-site-title';
	$mod = get_theme_mod( $setting, customizer_library_get_default( $setting ) );

	if ( $mod !== customizer_library_get_default( $setting ) ) {

		$color = sanitize_hex_color( $mod );

		Customizer_Library_Styles()->add( array(
			'selectors' => array(
				'.site-header .site-branding h1.site-title a'
			),
			'declarations' => array(
				'color' => $color
			)
		) );
	}

	// Color: Tagline
	$setting = 'color-site-tagline';
	$mod = get_theme_mod( $setting, customizer_library_get_default( $setting ) );

	if ( $mod !== customizer_library_get_default( $setting ) ) {

		$color = sanitize_hex_color( $mod );

		Customizer_Library_Styles()->add( array(
			'selectors' => array(
				'.site-header .site-branding p.site-description'
			),
			'declarations' => array(
				'color' => $color
			)
		) );
	}

/*--------------------------------------------------------------
6.4 Colors: Sidebar
--------------------------------------------------------------*/
	// Color: Widget Title
	$setting = 'color-sidebar-widget-title';
	$mod = get_theme_mod( $setting, customizer_library_get_default( $setting ) );

	if ( $mod !== customizer_library_get_default( $setting ) ) {

		$color = sanitize_hex_color( $mod );

		Customizer_Library_Styles()->add( array(
			'selectors' => array(
				'.inner-sidebar h2.widget-title'
			),
			'declarations' => array(
				'color' => $color
			)
		) );
	}

	// Color: Widget Content
	$setting = 'color-sidebar-widget-content';
	$mod = get_theme_mod( $setting, customizer_library_get_default( $setting ) );

	if ( $mod !== customizer_library_get_default( $setting ) ) {

		$color = sanitize_hex_color( $mod );

		Customizer_Library_Styles()->add( array(
			'selectors' => array(
				'.inner-sidebar aside'
			),
			'declarations' => array(
				'color' => $color
			)
		) );
	}

	// Color: Links
	$setting = 'color-sidebar-widget-links';
	$mod = get_theme_mod( $setting, customizer_library_get_default( $setting ) );

	if ( $mod !== customizer_library_get_default( $setting ) ) {

		$color = sanitize_hex_color( $mod );

		Customizer_Library_Styles()->add( array(
			'selectors' => array(
				'.inner-sidebar aside a'
			),
			'declarations' => array(
				'color' => $color
			)
		) );
	}

	// Color: Link Hover
	$setting = 'color-sidebar-widget-link-hover';
	$mod = get_theme_mod( $setting, customizer_library_get_default( $setting ) );

	if ( $mod !== customizer_library_get_default( $setting ) ) {

		$color = sanitize_hex_color( $mod );

		Customizer_Library_Styles()->add( array(
			'selectors' => array(
				'.inner-sidebar aside a:hover, #wp-calendar tbody td:hover a'
			),
			'declarations' => array(
				'color' => $color
			)
		) );
	}

/*--------------------------------------------------------------
6.5 Colors: Footer
--------------------------------------------------------------*/
	// Color Footer: Background
	$setting = 'color-footer-bg';
	$mod = get_theme_mod( $setting, customizer_library_get_default( $setting ) );

	if ( $mod !== customizer_library_get_default( $setting ) ) {

		$color = sanitize_hex_color( $mod );

		Customizer_Library_Styles()->add( array(
			'selectors' => array(
				'.footer-wrap'
			),
			'declarations' => array(
				'background-color' => $color
			)
		) );
	}

	// Color Footer: Widget Title
	$setting = 'color-footer-widget-title';
	$mod = get_theme_mod( $setting, customizer_library_get_default( $setting ) );

	if ( $mod !== customizer_library_get_default( $setting ) ) {

		$color = sanitize_hex_color( $mod );

		Customizer_Library_Styles()->add( array(
			'selectors' => array(
				'.footer-wrap .widget-title'
			),
			'declarations' => array(
				'color' => $color
			)
		) );
	}

	// Color Footer: Widget Content
	$setting = 'color-footer-widget-content';
	$mod = get_theme_mod( $setting, customizer_library_get_default( $setting ) );

	if ( $mod !== customizer_library_get_default( $setting ) ) {

		$color = sanitize_hex_color( $mod );

		Customizer_Library_Styles()->add( array(
			'selectors' => array(
				'.site-footer aside'
			),
			'declarations' => array(
				'color' => $color
			)
		) );
	}

	// Color Footer: Widget Links
	$setting = 'color-footer-widget-links';
	$mod = get_theme_mod( $setting, customizer_library_get_default( $setting ) );

	if ( $mod !== customizer_library_get_default( $setting ) ) {

		$color = sanitize_hex_color( $mod );

		Customizer_Library_Styles()->add( array(
			'selectors' => array(
				'.site-footer aside a'
			),
			'declarations' => array(
				'color' => $color
			)
		) );
	}

	// Color Footer: Widget Link Hover
	$setting = 'color-footer-widget-links-hover';
	$mod = get_theme_mod( $setting, customizer_library_get_default( $setting ) );

	if ( $mod !== customizer_library_get_default( $setting ) ) {

		$color = sanitize_hex_color( $mod );

		Customizer_Library_Styles()->add( array(
			'selectors' => array(
				'.site-footer aside a:hover'
			),
			'declarations' => array(
				'color' => $color
			)
		) );
	}

	// Color Footer: Copyright Text
	$setting = 'color-copyright-text';
	$mod = get_theme_mod( $setting, customizer_library_get_default( $setting ) );

	if ( $mod !== customizer_library_get_default( $setting ) ) {

		$color = sanitize_hex_color( $mod );

		Customizer_Library_Styles()->add( array(
			'selectors' => array(
				'.footer-wrap .copyright-info'
			),
			'declarations' => array(
				'color' => $color
			)
		) );
	}

	// Color Footer: Copyright Links
	$setting = 'color-copyright-links';
	$mod = get_theme_mod( $setting, customizer_library_get_default( $setting ) );

	if ( $mod !== customizer_library_get_default( $setting ) ) {

		$color = sanitize_hex_color( $mod );

		Customizer_Library_Styles()->add( array(
			'selectors' => array(
				'.footer-wrap .copyright-info a'
			),
			'declarations' => array(
				'color' => $color
			)
		) );
	}

	// Color Footer: Copyright Link Hover
	$setting = 'color-copyright-hover';
	$mod = get_theme_mod( $setting, customizer_library_get_default( $setting ) );

	if ( $mod !== customizer_library_get_default( $setting ) ) {

		$color = sanitize_hex_color( $mod );

		Customizer_Library_Styles()->add( array(
			'selectors' => array(
				'.footer-wrap .copyright-info a:hover'
			),
			'declarations' => array(
				'color' => $color
			)
		) );
	}
	
	// Image Effects
	$setting = 'enable-image-effects';
	$mod = get_theme_mod( $setting, customizer_library_get_default( $setting ) );

	if ( $mod !== customizer_library_get_default( $setting ) ) {

		$text = customizer_library_sanitize_text( $mod );

		Customizer_Library_Styles()->add( array(
			'selectors' => array(
				'.blog .content-area img, .home .image img, .single .featured-image img'
			),
			'declarations' => array(
				'opacity' => 1.0
			)
		) );
	}



}
endif;

add_action( 'customizer_library_styles', 'customizer_library_demo_build_styles' );

if ( ! function_exists( 'customizer_library_demo_styles' ) ) :
/**
 * Generates the style tag and CSS needed for the theme options.
 *
 * By using the "Customizer_Library_Styles" filter, different components can print CSS in the header.
 * It is organized this way to ensure there is only one "style" tag.
 *
 * @since  1.0.0.
 *
 * @return void
 */
function customizer_library_demo_styles() {

	do_action( 'customizer_library_styles' );

	echo "\n<!-- Begin Custom CSS -->\n<style type=\"text/css\" id=\"politics-plus-custom-css\">\n";

	$politics_plug_logo_height = get_theme_mod( 'politics-plus-logo-height', customizer_library_get_default( 'politics-plus-logo-height' ) );
	$politics_plus_logo_width = get_theme_mod( 'politics-plus-logo-width', customizer_library_get_default( 'politics-plus-logo-width' ) );

	if ( $politics_plug_logo_height || $politics_plus_logo_width ) { ?>
		.site-branding img {
			height: <?php echo esc_attr( $politics_plug_logo_height ) ?>;
			width: <?php echo esc_attr( $politics_plus_logo_width ) ?>;
		}
	<?php }


	$home_paralax_bg = get_theme_mod( 'home_paralax_bg', customizer_library_get_default( 'home_paralax_bg' ) );
	$home_paralax_bg_color = get_theme_mod( 'home_paralax_bg_color', customizer_library_get_default( 'home_paralax_bg_color' ) );
	?>



  .home .home_paralax::before {
    background-color: <?php echo esc_attr( $home_paralax_bg_color ) ?>;
    background: url('<?php echo esc_url( $home_paralax_bg ) ?>') no-repeat center center;
    background-size: cover;
  }

	<?php

	// Echo the rules
	$css = Customizer_Library_Styles()->build();

	if ( ! empty( $css ) ) {
		echo $css;
	}
	echo "\n</style>\n<!-- End Custom CSS -->\n";
}
endif;

add_action( 'wp_head', 'customizer_library_demo_styles', 11 );
