<?php

/**
 * Remove Default Options
 */
function politics_plus_customize_register( $wp_customize ) {
	// Remove the default colors section
	$wp_customize->remove_section('colors');
	// Remove the default background image section
	$wp_customize->remove_section('background_image');
}
add_action( 'customize_register', 'politics_plus_customize_register' );

/**
 * Defines customizer options
 */
function politics_plus_customizer_library_options() {

	// Theme defaults
	$primary_color = '#5bc08c';
	$secondary_color = '#666';
	$white = '#fff';
	$primary_color_drkblue = '#465a63';

	// Image path default
	$imagepath =  get_template_directory_uri() . '/img/';

	// Get Categories
	$options_cats = array();
	$options_cats_obj = get_categories( 'type=post');
	$options_cats[''] = __( 'Select a Category', 'politics-plus' );
	foreach ($options_cats_obj as $cat) {
		$options_cats[$cat->term_id] = $cat->cat_name;
	}

	// Stores all the controls that will be added
	$options = array();

	// Stores all the sections to be added
	$sections = array();

	// Stores all the panels to be added
	$panels = array();

	// Adds the sections to the $options array
	$options['sections'] = $sections;


/*--------------------------------------------------------------
>>> TABLE OF CONTENTS:
----------------------------------------------------------------
1.0 Header
2.0 Home
	2.1 Home posts
	2.2 Secondary Content
	2.3 Paralax
	2.4 Slider
3.0 Footer
4.0 Blog
5.0 Typography
	5.1 Typography: Global
	5.2 Typography: Headers
	5.3 Typography: Site Title & Tagline
	5.4 Typography: Navigation
	5.5 Typography: Sidebar
	5.6 Typography: Footer
	5.7 Typography: Copyright
6.0 Colors
	6.1 Colors: Sitewide
	6.2 Colors: Navigation
	6.3 Colors: Title & Tagline
	6.4 Colors: Sidebar
	6.5 Colors: Footer
7.0 Image Effects


--------------------------------------------------------------*/

/*--------------------------------------------------------------
1.0 Header
--------------------------------------------------------------*/

	// Header Panel
	$panel = 'header-panel';

	$panels[] = array(
		'id' => $panel,
		'title' => __( 'Header', 'politics-plus' ),
		'priority' => '5'
	);

	$section = 'general';

	$sections[] = array(
		'id' => $section,
		'title' => __( 'General', 'politics-plus' ),
		'priority' => '5',
		'description' => __( 'General header settings', 'politics-plus' ),
		'panel' => $panel
	);

	$options['politics-plus-sticky-header'] = array(
		'id' => 'politics-plus-sticky-header',
		'label'   => __( 'Sticky Header', 'politics-plus' ),
		'section' => $section,
		'type'    => 'checkbox',
		'default' => 0,
	);

	$section = 'logo';

	$sections[] = array(
		'id' => $section,
		'title' => __( 'Logo', 'politics-plus' ),
		'priority' => '10',
		'description' => __( 'Upload the logo image', 'politics-plus' ),
		'panel' => $panel
	);

	$options['politics-plus-logo'] = array(
		'id' => 'politics-plus-logo',
		'label'   => __( 'Logo', 'politics-plus' ),
		'section' => $section,
		'type'    => 'image',
		'default' => $imagepath . 'logo.png'
	);

	$options['politics-plus-logo-height'] = array(
		'id' => 'politics-plus-logo-height',
		'label'   => __( 'Logo Height (px or em)', 'politics-plus' ),
		'section' => $section,
		'type'    => 'text'
	);

	$options['politics-plus-logo-width'] = array(
		'id' => 'politics-plus-logo-width',
		'label'   => __( 'Logo Width (px or em)', 'politics-plus' ),
		'section' => $section,
		'type'    => 'text',
		'default' => '225px'
	);

	$section = 'contact';

	$sections[] = array(
		'id' => $section,
		'title' => __( 'Contact Details', 'politics-plus' ),
		'priority' => '10',
		'description' => __( 'Contact details displayed in the top header', 'politics-plus' ),
		'panel' => $panel
	);

	$options['politics-plus-header-phone'] = array(
		'id' => 'politics-plus-header-phone',
		'label'   => __( 'Phone Number', 'politics-plus' ),
		'section' => $section,
		'type'    => 'textarea',
		'default' => __( '800 555 1234', 'politics-plus'),
		'transport'	=> 'postMessage'
	);

	$options['politics-plus-header-address'] = array(
		'id' => 'politics-plus-header-address',
		'label'   => __( 'Location', 'politics-plus' ),
		'section' => $section,
		'type'    => 'textarea',
		'default' => __( '5046 S Greenwood, Chicago USA', 'politics-plus'),
		'transport'	=> 'postMessage'
	);

/*--------------------------------------------------------------
2.0 Home
--------------------------------------------------------------*/
	// Home Panel
	$panel = 'home-panel';

	$panels[] = array(
		'id' => $panel,
		'title' => __( 'Home', 'politics-plus' ),
		'priority' => '10'
	);


/*--------------------------------------------------------------
2.1 Home Posts
--------------------------------------------------------------*/
	$section = 'home-featured-posts';

	$sections[] = array(
		'id' => $section,
		'title' => __( 'Featured Posts', 'politics-plus' ),
		'priority' => '15',
		'description' => __( 'Settings for the featured posts section', 'politics-plus' ),
		'panel' => $panel
	);

	$options['home_posts_section_title'] = array(
		'id' 						=> 'home_posts_section_title',
		'label'   			=> __( 'Section Title', 'politics-plus' ),
		'section' 			=> $section,
		'type'    			=> 'textarea',
		'default' 			=> __( 'Latest News', 'politics-plus' ),
		'transport'			=> 'postMessage'
	);

	$options['home_posts_section_subtitle'] = array(
		'id' => 'home_posts_section_subtitle',
		'label'   		=> __( 'Section Subtitle', 'politics-plus' ),
		'section' 		=> $section,
		'type'    		=> 'textarea',
		'default' 		=> __( 'Change this text in the theme customizer', 'politics-plus' ),
		'transport'		=> 'postMessage'
	);

	$options['home_posts_cat'] = array(
		'id' 				=> 'home_posts_cat',
		'label'   			=> __( 'Home Posts Category', 'politics-plus' ),
		'section' 			=> $section,
		'type'    			=> 'select',
		'choices' 			=> $options_cats
	);

/*--------------------------------------------------------------
2.2 Secondary Content
--------------------------------------------------------------*/
	$section = 'home-secondary-content';

	$sections[] = array(
		'id' => $section,
		'title' => __( 'Secondary Content', 'politics-plus' ),
		'priority' => '20',
		'description' => __( 'Settings for the secondary content section on the home page', 'politics-plus' ),
		'panel' => $panel
	);

	$options['home_secondary_content_page'] = array(
		'id' => 'home_secondary_content_page',
		'label' => __( 'Secondary Content Page', 'politics-plus' ),
		'section' => $section,
		'type' => 'dropdown-pages',
		'default' => ''
	);

	$options['home_secondary_content_title'] = array(
		'id' 						=> 'home_secondary_content_title',
		'label'   			=> __( 'Section Title', 'politics-plus' ),
		'section' 			=> $section,
		'type'    			=> 'textarea',
		'default' 			=> __( 'Community', 'politics-plus' ),
		'transport'			=> 'postMessage'
	);

	$options['home_secondary_content_subtitle'] = array(
		'id' => 'home_secondary_content_subtitle',
		'label'   		=> __( 'Section Subtitle', 'politics-plus' ),
		'section' 		=> $section,
		'type'    		=> 'textarea',
		'default' 		=> __( 'Change this text in the theme customizer', 'politics-plus' ),
		'transport'		=> 'postMessage'
	);


/*--------------------------------------------------------------
2.3 Paralax Content
--------------------------------------------------------------*/
	$section = 'home-paralax-content';

	$sections[] = array(
		'id' => $section,
		'title' => __( 'Paralax Content', 'politics-plus' ),
		'priority' => '25',
		'description' => __( 'Settings for the paralax content section on the home page', 'politics-plus' ),
		'panel' => $panel
	);

	$options['home_paralax_content_page'] = array(
		'id' => 'home_paralax_content_page',
		'label' => __( 'Paralax Content Page', 'politics-plus' ),
		'section' => $section,
		'type' => 'dropdown-pages',
		'default' => ''
	);

	$options['home_paralax_bg'] = array(
		'id' 				=> 'home_paralax_bg',
		'label'   			=> __( 'Background Image', 'politics-plus' ),
		'section' 			=> $section,
		'type'    			=> 'image',
		'default' 			=> $imagepath . 'home-paralax.jpg'
	);

	$options['home_paralax_bg_color'] = array(
		'id' 				=> 'home_paralax_bg_color',
		'label'   			=> __( 'Background color if no image is being used', 'politics-plus' ),
		'section' 			=> $section,
		'type'    			=> 'color',
		'default' 			=> $primary_color_drkblue
	);

/*--------------------------------------------------------------
2.4 Slider
--------------------------------------------------------------*/
/**
 * Section named 'header_image' so that
 * add_theme_support( 'custom-header' ) will display in
 * this section.
 *
 * @see politics_plus_backstretch_setup()
 */
	$section = 'header_image';

	$sections[] = array(
		'id' 			=> $section,
		'title' 		=> __( 'Hero Slider', 'politics-plus' ),
		'priority' 		=> '5',
		'description' 	=> __( 'Settings for the home slider.', 'politics-plus' ),
		'panel' => $panel
	);

	$options['home-slider-content-help'] = array(
		'id' => 'home-slider-content-help',
        'section' => $section,
        'label'    => 'Content',
        'type'     => 'content',
		'description' 	=> __( 'The content area is widgetized. To add content (text, buttons, etc.), add a widget at Widgets > Home Hero', 'politics-plus' )
	);

	$options['home_duration'] = array(
	    'id' => 'home_duration',
	    'label'   => __( 'Images Duration', 'brewery' ),
	    'section' => $section,
	    'type'    => 'range',
	    'description' => __( 'Duration time for each background image.', 'brewery' ),
	    'default' => 4000,
	    'input_attrs' => array(
	        'min'   => 100,
	        'max'   => 10000,
	        'step'  => 100,
	    )
	);

	$options['home_fade'] = array(
	    'id' => 'home_fade',
	    'label'   => __( 'Image Fade In', 'brewery' ),
	    'section' => $section,
	    'type'    => 'range',
	    'description' => __( 'Fade in duration for each background image.', 'brewery' ),
	    'default' => 1000,
	    'input_attrs' => array(
	        'min'   => 100,
	        'max'   => 3000,
	        'step'  => 100,
	    )
	);

	$options['home_overlay_color'] = array(
		'id' => 'home_overlay_color',
		'label'   => __( 'Overlay Color', 'merch' ),
		'description' => __( 'Color overlayed on the home page images.', 'merch' ),
		'section' => $section,
		'type'    => 'color',
		'default' => $primary_color_drkblue,
	);

	$options['home_opacity'] = array(
		'id' => 'home_opacity',
		'label'   => __( 'Opacity level', 'merch' ),
		'section' => $section,
		'type'    => 'range',
		'description' => __( 'Adjust the opacity for the overlay color.', 'merch' ),
		'default' => '0.6',
	    'input_attrs' => array(
	        'min'   => 0,
	        'max'   => 1,
	        'step'  => 0.1
	    ),
	);

/*--------------------------------------------------------------
3.0 Footer
--------------------------------------------------------------*/
	// Home Panel
	$panel = 'footer-panel';

	$panels[] = array(
		'id' => $panel,
		'title' => __( 'Footer', 'politics-plus' ),
		'priority' => '15'
	);

	$section = 'footer-section';

	$sections[] = array(
		'id' => $section,
		'title' => __( 'Copyright', 'politics-plus' ),
		'priority' => '30',
		'description' => __( 'Settings for the copyright area', 'politics-plus' ),
		'panel' => $panel
	);

	$options['footer_copyright'] = array(
		'id' => 'footer_copyright',
		'label'   		=> __( 'Copyright Text', 'politics-plus' ),
		'section' 		=> $section,
		'type'    		=> 'textarea',
		'default' 		=> __( 'Copyright 2015 <a href="https://rescuethemes.com">Rescue Themes</a>. All Rights Reserved. Paid for by the campaign.', 'politics-plus' ),
		'transport'		=> 'postMessage'
	);

/*--------------------------------------------------------------
4.0 Blog
--------------------------------------------------------------*/
	// Blog Panel
	$panel = 'blog-panel';

	$panels[] = array(
		'id' => $panel,
		'title' => __( 'Blog', 'politics-plus' ),
		'priority' => '20'
	);

	$section = 'blog-layout-section';

	$sections[] = array(
		'id' => $section,
		'title' => __( 'Layout', 'politics-plus' ),
		'priority' => '30',
		'description' => __( 'Settings for the blog page layout', 'politics-plus' ),
		'panel' => $panel
	);

	$choices = array(
		'masonry' => 'Masonry',
		'traditional' => 'Traditional'
	);

	$options['politics_plus_blog_style'] = array(
		'id' => 'politics_plus_blog_style',
		'label'   => __( 'Blog Page Style', 'politics-plus' ),
		'section' => $section,
		'type'    => 'select',
		'choices' => $choices,
		'default' => 'masonry'
	);

	$section = 'blog-title-section';

	$sections[] = array(
		'id' => $section,
		'title' => __( 'Header', 'politics-plus' ),
		'priority' => '30',
		'description' => __( 'Settings for the blog page header', 'politics-plus' ),
		'panel' => $panel
	);

	$options['politics_plus_blog_title'] = array(
		'id' => 'politics_plus_blog_title',
		'label'   		=> __( 'Page Title', 'politics-plus' ),
		'section' 		=> $section,
		'type'    		=> 'textarea',
		'default' 		=> __( 'Latest Posts', 'politics-plus' ),
		'transport'		=> 'postMessage'
	);

	$options['politics_plus_blog_subtitle'] = array(
		'id' => 'politics_plus_blog_subtitle',
		'label'   		=> __( 'Page Subtitle', 'politics-plus' ),
		'section' 		=> $section,
		'type'    		=> 'textarea',
		'default' 		=> __( 'Change this text in the customizer', 'politics-plus' ),
		'transport'		=> 'postMessage'
	);

	$section = 'blog-sidebar-section';

	$sections[] = array(
		'id' => $section,
		'title' => __( 'Sidebar', 'politics-plus' ),
		'priority' => '35',
		'description' => __( 'Settings for the inner pages sidebar.', 'politics-plus' ),
		'panel' => $panel
	);

	$sidebar_choices = array(
	    'left'  => array(
	        'url' => $imagepath .'sidebar-l.png',
	        'label' => 'Left'
	    ),
	    'right' => array(
	        'url' => $imagepath .'sidebar-r.png',
	        'label' => 'Right'
	    ),
	);

	$options['blog_sidebar_position'] = array(
	    'id'            => 'blog_sidebar_position',
	    'label'         => __( 'Sidebar Position', 'politics-plus' ),
	    'section'       => $section,
	    'type'          => 'radio-image',
	    'choices'       => $sidebar_choices,
	    'default'       => 'right'
	);


/*--------------------------------------------------------------
5.0 Typography
--------------------------------------------------------------*/

	$panel = 'Typography';

	$panels[] = array(
	    'id' => $panel,
	    'title' => __( 'Typography', 'politics-plus' ),
	    'priority' => '25'
	);

	// Font Weight
	$font_weight = array(
	    'normal' 	=> 'Normal',
	    'bold' 		=> 'Bold',
	);

	// Font Style
	$font_style = array(
	    'normal' 	=> 'Normal',
	    'italic' 	=> 'Italic',
	);

	// Text Transform
	$text_transform = array(
	    'none' 		=> 'None',
	    'uppercase' => 'Uppercase',
	    'lowercase' => 'Lowercase'
	);

	// Text Transform
	$links_underline = array(
	    'underline' => 'Always',
	    'none'		=> 'Never'
	);

	$font_choices = customizer_library_get_font_choices();

/*--------------------------------------------------------------
5.1 Typography: Global
--------------------------------------------------------------*/
	$section = 'typography-global';

	$sections[] = array(
		'id' => $section,
		'title' => __( 'Global', 'politics-plus' ),
		'priority' => '5',
		'panel' => $panel
	);

	$options['type-global-links-header'] = array(
	    'id' => 'type-global-links-header',
	    'label' => __( 'Sitewide Content Links', 'politics-plus' ),
	    'section' => $section,
	    'type' => 'content'
	);

	$options['type-global-links-weight'] = array(
	    'id' 		=> 'type-global-links-weight',
	    'label'   	=> __( 'Link Font Weight', 'politics-plus' ),
	    'section' 	=> $section,
	    'type'    	=> 'select',
	    'choices' 	=> $font_weight,
	    'default' 	=> 'normal',
	    'transport'	=> 'postMessage'
	);

	$options['type-global-links-underline'] = array(
	    'id' 		=> 'type-global-links-underline',
	    'label'   	=> __( 'Link Underline', 'politics-plus' ),
	    'section' 	=> $section,
	    'type'    	=> 'select',
	    'choices' 	=> $links_underline,
	    'default' 	=> 'none',
	    'transport'	=> 'postMessage'
	);

/*--------------------------------------------------------------
5.2 Typography: Headers
--------------------------------------------------------------*/
	$section = 'typography-headers';

	$sections[] = array(
		'id' => $section,
		'title' => __( 'Headers', 'politics-plus' ),
		'priority' => '10',
		'panel' => $panel
	);

	$options['type-header-header'] = array(
	    'id' => 'type-header-header',
	    'label' => __( 'Sitewide Header Text', 'politics-plus' ),
	    'section' => $section,
	    'type' => 'content'
	);

	$options['type-header-font-family'] = array(
		'id' => 'type-header-font-family',
		'label'   => __( 'Font Family', 'politics-plus' ),
		'section' => $section,
		'type'    => 'select',
		'choices' => $font_choices,
		'default' => 'Lora',
		'transport'	=> 'postMessage'
	);

	$options['type-header-font-weight'] = array(
	    'id' 		=> 'type-header-font-weight',
	    'label'   	=> __( 'Font Weight', 'politics-plus' ),
	    'section' 	=> $section,
	    'type'    	=> 'select',
	    'choices' 	=> $font_weight,
	    'default' 	=> 'normal',
	    'transport'	=> 'postMessage'
	);

	$options['type-header-font-style'] = array(
	    'id' 		=> 'type-header-font-style',
	    'label'   	=> __( 'Font Style', 'politics-plus' ),
	    'section' 	=> $section,
	    'type'    	=> 'select',
	    'choices' 	=> $font_style,
	    'default' 	=> 'normal',
	    'transport'	=> 'postMessage'
	);

	$options['type-header-text-transform'] = array(
	    'id' 		=> 'type-header-text-transform',
	    'label'   	=> __( 'Text Transform', 'politics-plus' ),
	    'section' 	=> $section,
	    'type'    	=> 'select',
	    'choices' 	=> $text_transform,
	    'default' 	=> 'none',
	    'transport'	=> 'postMessage'
	);

	$options['type-header-line-height'] = array(
	    'id' => 'type-header-line-height',
	    'label'   => __( 'Line Height', 'politics-plus' ),
	    'section' => $section,
	    'type'    => 'text',
	    'default' => '1.4',
	    'transport'	=> 'postMessage'
	);

	$options['type-header-letter-spacing'] = array(
	    'id' => 'type-header-letter-spacing',
	    'label'   => __( 'Letter Spacing (px or em)', 'politics-plus' ),
	    'section' => $section,
	    'type'    => 'text',
	    'default' => '0.01em',
	    'transport'	=> 'postMessage'
	);

	$options['type-header-word-spacing'] = array(
	    'id' => 'type-header-word-spacing',
	    'label'   => __( 'Word Spacing (px or em)', 'politics-plus' ),
	    'section' => $section,
	    'type'    => 'text',
	    'default' => '0px',
	    'transport'	=> 'postMessage'
	);
/*--------------------------------------------------------------
5.3 Typography: Site Title & Tagline
--------------------------------------------------------------*/
	$section = 'typography-sitetitle-tagline';

	$sections[] = array(
		'id' => $section,
		'title' => __( 'Site Title & Tagline', 'politics-plus' ),
		'priority' => '15',
		'panel' => $panel,
		'description' 	=> __( 'Set the title and tagline under the "Site Identity" customizer panel.', 'politics-plus' )
	);

	/**
	* Typography: Site Title
	*
	*/
	$options['type-sitetitle-header'] = array(
	    'id' => 'type-sitetitle-header',
	    'label' => __( 'Title', 'politics-plus' ),
	    'section' => $section,
	    'type' => 'content',
			'description' 	=> __( 'The Site Title will display if no logo image is uploaded into the header.', 'politics-plus' )
	);

	$options['type-sitetitle-font-family'] = array(
		'id' => 'type-sitetitle-font-family',
		'label'   => __( 'Font Family', 'politics-plus' ),
		'section' => $section,
		'type'    => 'select',
		'choices' => $font_choices,
		'default' => 'Lora',
		'transport'	=> 'postMessage'
	);

	$options['type-sitetitle-font-size'] = array(
			'id' => 'type-sitetitle-font-size',
			'label'   => __( 'Font Size (px or em)', 'politics-plus' ),
			'section' => $section,
			'type'    => 'text',
			'default' => '1.5rem',
			'transport'	=> 'postMessage'
	);

	$options['type-sitetitle-font-weight'] = array(
			'id' 		=> 'type-sitetitle-font-weight',
			'label'   	=> __( 'Font Weight', 'politics-plus' ),
			'section' 	=> $section,
			'type'    	=> 'select',
			'choices' 	=> $font_weight,
			'default' 	=> 'normal',
			'transport'	=> 'postMessage'
	);

	$options['type-sitetitle-font-style'] = array(
			'id' 		=> 'type-sitetitle-font-style',
			'label'   	=> __( 'Font Style', 'politics-plus' ),
			'section' 	=> $section,
			'type'    	=> 'select',
			'choices' 	=> $font_style,
			'default' 	=> 'normal',
			'transport'	=> 'postMessage'
	);

	$options['type-sitetitle-text-transform'] = array(
			'id' 		=> 'type-sitetitle-text-transform',
			'label'   	=> __( 'Text Transform', 'politics-plus' ),
			'section' 	=> $section,
			'type'    	=> 'select',
			'choices' 	=> $text_transform,
			'default' 	=> 'none',
			'transport'	=> 'postMessage'
	);

	$options['type-sitetitle-line-height'] = array(
			'id' => 'type-sitetitle-line-height',
			'label'   => __( 'Line Height', 'politics-plus' ),
			'section' => $section,
			'type'    => 'text',
			'default' => '1.5',
			'transport'	=> 'postMessage'
	);

	$options['type-sitetitle-letter-spacing'] = array(
			'id' => 'type-sitetitle-letter-spacing',
			'label'   => __( 'Letter Spacing (px or em)', 'politics-plus' ),
			'section' => $section,
			'type'    => 'text',
			'default' => '0.01em',
			'transport'	=> 'postMessage'
	);

	$options['type-sitetitle-word-spacing'] = array(
			'id' => 'type-sitetitle-word-spacing',
			'label'   => __( 'Word Spacing (px or em)', 'politics-plus' ),
			'section' => $section,
			'type'    => 'text',
			'default' => '0px',
			'transport'	=> 'postMessage'
	);

	$options['type-sitetagline-hr'] = array(
		'id' => 'type-sitetagline-hr',
		'section' => $section,
		//'label'    => __( 'HR', 'politics-plus' ),
		'type'     => 'content',
		'description' 	=> __( '<hr>', 'politics-plus' )
	);

	/**
	* Typography: Site Tagline
	*
	*/
	$options['type-sitetagline-header'] = array(
	    'id' => 'type-sitetagline-header',
	    'label' => __( 'Tagline', 'politics-plus' ),
	    'section' => $section,
	    'type' => 'content',
			'description' 	=> __( 'The Tagline will display if no logo image is uploaded into the header.', 'politics-plus' )
	);

	$options['type-sitetagline-font-family'] = array(
		'id' => 'type-sitetagline-font-family',
		'label'   => __( 'Font Family', 'politics-plus' ),
		'section' => $section,
		'type'    => 'select',
		'choices' => $font_choices,
		'default' => 'Open Sans',
		'transport'	=> 'postMessage'
	);

	$options['type-sitetagline-font-size'] = array(
			'id' => 'type-sitetagline-font-size',
			'label'   => __( 'Font Size (px or em)', 'politics-plus' ),
			'section' => $section,
			'type'    => 'text',
			'default' => '0.85rem',
			'transport'	=> 'postMessage'
	);

	$options['type-sitetagline-font-weight'] = array(
			'id' 		=> 'type-sitetagline-font-weight',
			'label'   	=> __( 'Font Weight', 'politics-plus' ),
			'section' 	=> $section,
			'type'    	=> 'select',
			'choices' 	=> $font_weight,
			'default' 	=> 'normal',
			'transport'	=> 'postMessage'
	);

	$options['type-sitetagline-font-style'] = array(
			'id' 		=> 'type-sitetagline-font-style',
			'label'   	=> __( 'Font Style', 'politics-plus' ),
			'section' 	=> $section,
			'type'    	=> 'select',
			'choices' 	=> $font_style,
			'default' 	=> 'italic',
			'transport'	=> 'postMessage'
	);

	$options['type-sitetagline-text-transform'] = array(
			'id' 		=> 'type-sitetagline-text-transform',
			'label'   	=> __( 'Text Transform', 'politics-plus' ),
			'section' 	=> $section,
			'type'    	=> 'select',
			'choices' 	=> $text_transform,
			'default' 	=> 'none',
			'transport'	=> 'postMessage'
	);

	$options['type-sitetagline-line-height'] = array(
			'id' => 'type-sitetagline-line-height',
			'label'   => __( 'Line Height', 'politics-plus' ),
			'section' => $section,
			'type'    => 'text',
			'default' => '1.4',
			'transport'	=> 'postMessage'
	);

	$options['type-sitetagline-letter-spacing'] = array(
			'id' => 'type-sitetagline-letter-spacing',
			'label'   => __( 'Letter Spacing (px or em)', 'politics-plus' ),
			'section' => $section,
			'type'    => 'text',
			'default' => '0.01em',
			'transport'	=> 'postMessage'
	);

	$options['type-sitetagline-word-spacing'] = array(
			'id' => 'type-sitetagline-word-spacing',
			'label'   => __( 'Word Spacing (px or em)', 'politics-plus' ),
			'section' => $section,
			'type'    => 'text',
			'default' => '0px',
			'transport'	=> 'postMessage'
	);


/*--------------------------------------------------------------
5.4 Typography: Navigation
--------------------------------------------------------------*/
	$section = 'type-navigation';

	$sections[] = array(
		'id' => $section,
		'title' => __( 'Navigation', 'politics-plus' ),
		'priority' => '20',
		'panel' => $panel
	);

	// Main Menu
	$options['type-main-menu'] = array(
		'id' => 'type-main-menu',
		'section' => $section,
		'label'    => __( 'Main Menu', 'politics-plus' ),
		'type'     => 'content',
		'description' 	=> __( 'Font settings for the main site menu.', 'politics-plus' )
	);

	$options['type-main-menu-font-family'] = array(
		'id' => 'type-main-menu-font-family',
		'label'   => __( 'Font Family', 'politics-plus' ),
		'section' => $section,
		'type'    => 'select',
		'choices' => $font_choices,
		'default' => 'Open Sans',
		'transport'	=> 'postMessage'
	);

	$options['type-main-menu-font-size'] = array(
		'id' => 'type-main-menu-font-size',
		'label'   => __( 'Font Size (px or em)', 'politics-plus' ),
		'section' => $section,
		'type'    => 'text',
		'default' => '14px',
		'transport'	=> 'postMessage'
	);

	$options['type-main-menu-font-weight'] = array(
		'id' 		=> 'type-main-menu-font-weight',
		'label'   	=> __( 'Font Weight', 'politics-plus' ),
		'section' 	=> $section,
		'type'    	=> 'select',
		'choices' 	=> $font_weight,
		'default' 	=> 'normal',
		'transport'	=> 'postMessage'
	);

	$options['type-main-menu-font-style'] = array(
		'id' 		=> 'type-main-menu-font-style',
		'label'   	=> __( 'Font Style', 'politics-plus' ),
		'section' 	=> $section,
		'type'    	=> 'select',
		'choices' 	=> $font_style,
		'default' 	=> 'normal',
		'transport'	=> 'postMessage'
	);

	$options['type-main-menu-text-transform'] = array(
		'id' 		=> 'type-main-menu-text-transform',
		'label'   	=> __( 'Text Transform', 'politics-plus' ),
		'section' 	=> $section,
		'type'    	=> 'select',
		'choices' 	=> $text_transform,
		'default' 	=> 'uppercase',
		'transport'	=> 'postMessage'
	);

	$options['type-main-menu-line-height'] = array(
		'id' => 'type-main-menu-line-height',
		'label'   => __( 'Dropdown Line Height', 'politics-plus' ),
		'section' => $section,
		'type'    => 'text',
		'default' => '1.5',
		'transport'	=> 'postMessage'
	);

	$options['type-main-menu-letter-spacing'] = array(
		'id' => 'type-main-menu-letter-spacing',
		'label'   => __( 'Letter Spacing (px or em)', 'politics-plus' ),
		'section' => $section,
		'type'    => 'text',
		'default' => '0.01em',
		'transport'	=> 'postMessage'
	);

	$options['type-main-menu-word-spacing'] = array(
		'id' => 'type-main-menu-word-spacing',
		'label'   => __( 'Word Spacing (px or em)', 'politics-plus' ),
		'section' => $section,
		'type'    => 'text',
		'default' => '0px',
		'transport'	=> 'postMessage'
	);


/*--------------------------------------------------------------
5.5 Typography: Sidebar
--------------------------------------------------------------*/
$section = 'type-sidebar';

$sections[] = array(
	'id' => $section,
	'title' => __( 'Sidebar', 'politics-plus' ),
	'priority' => '25',
	'panel' => $panel
);

/**
* Widget Title
*
*/
$options['type-widget-title'] = array(
	'id' => 'type-widget-title',
			'section' => $section,
			'label'    => __( 'Widget Titles', 'politics-plus' ),
			'type'     => 'content',
	'description' 	=> __( 'Font settings for the sidebar widget titles.', 'politics-plus' )
);

$options['type-widget-title-font-family'] = array(
	'id' => 'type-widget-title-font-family',
	'label'   => __( 'Font Family', 'politics-plus' ),
	'section' => $section,
	'type'    => 'select',
	'choices' => $font_choices,
	'default' => 'Lora',
	'transport'	=> 'postMessage'
);

$options['type-widget-title-font-size'] = array(
		'id' => 'type-widget-title-font-size',
		'label'   => __( 'Font Size (px or em)', 'politics-plus' ),
		'section' => $section,
		'type'    => 'text',
		'default' => '16px',
		'transport'	=> 'postMessage'
);

$options['type-widget-title-font-weight'] = array(
		'id' 		=> 'type-widget-title-font-weight',
		'label'   	=> __( 'Font Weight', 'politics-plus' ),
		'section' 	=> $section,
		'type'    	=> 'select',
		'choices' 	=> $font_weight,
		'default' 	=> 'bold',
		'transport'	=> 'postMessage'
);

$options['type-widget-title-font-style'] = array(
		'id' 		=> 'type-widget-title-font-style',
		'label'   	=> __( 'Font Style', 'politics-plus' ),
		'section' 	=> $section,
		'type'    	=> 'select',
		'choices' 	=> $font_style,
		'default' 	=> 'italic',
		'transport'	=> 'postMessage'
);

$options['type-widget-title-text-transform'] = array(
		'id' 		=> 'type-widget-title-text-transform',
		'label'   	=> __( 'Text Transform', 'politics-plus' ),
		'section' 	=> $section,
		'type'    	=> 'select',
		'choices' 	=> $text_transform,
		'default' 	=> 'none',
		'transport'	=> 'postMessage'
);

$options['type-widget-title-line-height'] = array(
		'id' => 'type-widget-title-line-height',
		'label'   => __( 'Line Height', 'politics-plus' ),
		'section' => $section,
		'type'    => 'text',
		'default' => '1.5',
		'transport'	=> 'postMessage'
);

$options['type-widget-title-letter-spacing'] = array(
		'id' => 'type-widget-title-letter-spacing',
		'label'   => __( 'Letter Spacing (px or em)', 'politics-plus' ),
		'section' => $section,
		'type'    => 'text',
		'default' => '0.01em',
		'transport'	=> 'postMessage'
);

$options['type-widget-title-word-spacing'] = array(
		'id' => 'type-widget-title-word-spacing',
		'label'   => __( 'Word Spacing (px or em)', 'politics-plus' ),
		'section' => $section,
		'type'    => 'text',
		'default' => '0px',
		'transport'	=> 'postMessage'
);

$options['type-widget-hr'] = array(
	'id' => 'type-widget-hr',
	'section' => $section,
	//'label'    => __( 'HR', 'politics-plus' ),
	'type'     => 'content',
	'description' 	=> __( '<hr>', 'politics-plus' )
);

/**
* Widget Body
*
*/
$options['type-widget-body'] = array(
	'id' => 'type-widget-body',
			'section' => $section,
			'label'    => __( 'Widget Body', 'politics-plus' ),
			'type'     => 'content',
	'description' 	=> __( 'Font settings for the sidebar widget body content.', 'politics-plus' )
);

$options['type-widget-body-font-family'] = array(
	'id' => 'type-widget-body-font-family',
	'label'   => __( 'Font Family', 'politics-plus' ),
	'section' => $section,
	'type'    => 'select',
	'choices' => $font_choices,
	'default' => 'Lora',
	'transport'	=> 'postMessage'
);

$options['type-widget-body-font-size'] = array(
		'id' => 'type-widget-body-font-size',
		'label'   => __( 'Font Size (px or em)', 'politics-plus' ),
		'section' => $section,
		'type'    => 'text',
		'default' => '1rem',
		'transport'	=> 'postMessage'
);

$options['type-widget-body-font-weight'] = array(
		'id' 		=> 'type-widget-body-font-weight',
		'label'   	=> __( 'Font Weight', 'politics-plus' ),
		'section' 	=> $section,
		'type'    	=> 'select',
		'choices' 	=> $font_weight,
		'default' 	=> 'normal',
		'transport'	=> 'postMessage'
);

$options['type-widget-body-font-style'] = array(
		'id' 		=> 'type-widget-body-font-style',
		'label'   	=> __( 'Font Style', 'politics-plus' ),
		'section' 	=> $section,
		'type'    	=> 'select',
		'choices' 	=> $font_style,
		'default' 	=> 'normal',
		'transport'	=> 'postMessage'
);

$options['type-widget-body-text-transform'] = array(
		'id' 		=> 'type-widget-body-text-transform',
		'label'   	=> __( 'Text Transform', 'politics-plus' ),
		'section' 	=> $section,
		'type'    	=> 'select',
		'choices' 	=> $text_transform,
		'default' 	=> 'none',
		'transport'	=> 'postMessage'
);

$options['type-widget-body-line-height'] = array(
		'id' => 'type-widget-body-line-height',
		'label'   => __( 'Line Height', 'politics-plus' ),
		'section' => $section,
		'type'    => 'text',
		'default' => '1.6',
		'transport'	=> 'postMessage'
);

$options['type-widget-body-letter-spacing'] = array(
		'id' => 'type-widget-body-letter-spacing',
		'label'   => __( 'Letter Spacing (px or em)', 'politics-plus' ),
		'section' => $section,
		'type'    => 'text',
		'default' => '0.01em',
		'transport'	=> 'postMessage'
);

$options['type-widget-body-word-spacing'] = array(
		'id' => 'type-widget-body-word-spacing',
		'label'   => __( 'Word Spacing (px or em)', 'politics-plus' ),
		'section' => $section,
		'type'    => 'text',
		'default' => '0px',
		'transport'	=> 'postMessage'
);


/*--------------------------------------------------------------
5.6 Typography: Footer
--------------------------------------------------------------*/
	$section = 'type-footer';

	$sections[] = array(
		'id' => $section,
		'title' => __( 'Footer', 'politics-plus' ),
		'priority' => '30',
		'panel' => $panel
	);

/**
 * Widget Title
 *
 */
	$options['type-footer-widget-title'] = array(
		'id' => 'type-footer-widget-title',
    'section' => $section,
    'label'    => __( 'Widget Titles', 'politics-plus' ),
    'type'     => 'content',
		'description' 	=> __( 'Font settings for the footer widget titles.', 'politics-plus' )
	);

	$options['type-footer-widget-title-font-family'] = array(
		'id' => 'type-footer-widget-title-font-family',
		'label'   => __( 'Font Family', 'politics-plus' ),
		'section' => $section,
		'type'    => 'select',
		'choices' => $font_choices,
		'default' => 'Open Sans',
		'transport'	=> 'postMessage'
	);

	$options['type-footer-widget-title-font-size'] = array(
	    'id' => 'type-footer-widget-title-font-size',
	    'label'   => __( 'Font Size (px or em)', 'politics-plus' ),
	    'section' => $section,
	    'type'    => 'text',
	    'default' => '14px',
	    'transport'	=> 'postMessage'
	);

	$options['type-footer-widget-title-font-weight'] = array(
	    'id' 		=> 'type-footer-widget-title-font-weight',
	    'label'   	=> __( 'Font Weight', 'politics-plus' ),
	    'section' 	=> $section,
	    'type'    	=> 'select',
	    'choices' 	=> $font_weight,
	    'default' 	=> 'bold',
	    'transport'	=> 'postMessage'
	);

	$options['type-footer-widget-title-font-style'] = array(
	    'id' 		=> 'type-footer-widget-title-font-style',
	    'label'   	=> __( 'Font Style', 'politics-plus' ),
	    'section' 	=> $section,
	    'type'    	=> 'select',
	    'choices' 	=> $font_style,
	    'default' 	=> 'normal',
	    'transport'	=> 'postMessage'
	);

	$options['type-footer-widget-title-text-transform'] = array(
	    'id' 		=> 'type-footer-widget-title-text-transform',
	    'label'   	=> __( 'Text Transform', 'politics-plus' ),
	    'section' 	=> $section,
	    'type'    	=> 'select',
	    'choices' 	=> $text_transform,
	    'default' 	=> 'uppercase',
	    'transport'	=> 'postMessage'
	);

	$options['type-footer-widget-title-line-height'] = array(
	    'id' => 'type-footer-widget-title-line-height',
	    'label'   => __( 'Line Height', 'politics-plus' ),
	    'section' => $section,
	    'type'    => 'text',
	    'default' => '1.4',
	    'transport'	=> 'postMessage'
	);

	$options['type-footer-widget-title-letter-spacing'] = array(
	    'id' => 'type-footer-widget-title-letter-spacing',
	    'label'   => __( 'Letter Spacing (px or em)', 'politics-plus' ),
	    'section' => $section,
	    'type'    => 'text',
	    'default' => '0.01em',
	    'transport'	=> 'postMessage'
	);

	$options['type-footer-widget-title-word-spacing'] = array(
	    'id' => 'type-footer-widget-title-word-spacing',
	    'label'   => __( 'Word Spacing (px or em)', 'politics-plus' ),
	    'section' => $section,
	    'type'    => 'text',
	    'default' => '0px',
	    'transport'	=> 'postMessage'
	);

	$options['type-footer-widget-hr'] = array(
		'id' => 'type-footer-widget-hr',
    'section' => $section,
    'label'    => '',
    'type'     => 'content',
		'description' 	=> __( '<hr>', 'politics-plus' )
	);

/**
 * Widget Body
 */
	$options['type-footer-widget-body'] = array(
		'id' => 'type-footer-widget-body',
    'section' => $section,
    'label'    => __( 'Widget Body', 'politics-plus' ),
    'type'     => 'content',
		'description' 	=> __( 'Font settings for the sidebar widget body content.', 'politics-plus' )
	);

	$options['type-footer-widget-body-font-family'] = array(
		'id' => 'type-footer-widget-body-font-family',
		'label'   => __( 'Font Family', 'politics-plus' ),
		'section' => $section,
		'type'    => 'select',
		'choices' => $font_choices,
		'default' => 'Open Sans',
		'transport'	=> 'postMessage'
	);

	$options['type-footer-widget-body-font-size'] = array(
	    'id' => 'type-footer-widget-body-font-size',
	    'label'   => __( 'Font Size (px or em)', 'politics-plus' ),
	    'section' => $section,
	    'type'    => 'text',
	    'default' => '12px',
	    'transport'	=> 'postMessage'
	);

	$options['type-footer-widget-body-font-weight'] = array(
	    'id' 		=> 'type-footer-widget-body-font-weight',
	    'label'   	=> __( 'Font Weight', 'politics-plus' ),
	    'section' 	=> $section,
	    'type'    	=> 'select',
	    'choices' 	=> $font_weight,
	    'default' 	=> 'normal',
	    'transport'	=> 'postMessage'
	);

	$options['type-footer-widget-body-font-style'] = array(
	    'id' 		=> 'type-footer-widget-body-font-style',
	    'label'   	=> __( 'Font Style', 'politics-plus' ),
	    'section' 	=> $section,
	    'type'    	=> 'select',
	    'choices' 	=> $font_style,
	    'default' 	=> 'normal',
	    'transport'	=> 'postMessage'
	);

	$options['type-footer-widget-body-text-transform'] = array(
	    'id' 		=> 'type-footer-widget-body-text-transform',
	    'label'   	=> __( 'Text Transform', 'politics-plus' ),
	    'section' 	=> $section,
	    'type'    	=> 'select',
	    'choices' 	=> $text_transform,
	    'default' 	=> 'none',
	    'transport'	=> 'postMessage'
	);

	$options['type-footer-widget-body-line-height'] = array(
	    'id' => 'type-footer-widget-body-line-height',
	    'label'   => __( 'Line Height', 'politics-plus' ),
	    'section' => $section,
	    'type'    => 'text',
	    'default' => '1.5',
	    'transport'	=> 'postMessage'
	);

	$options['type-footer-widget-body-letter-spacing'] = array(
	    'id' => 'type-footer-widget-body-letter-spacing',
	    'label'   => __( 'Letter Spacing (px or em)', 'politics-plus' ),
	    'section' => $section,
	    'type'    => 'text',
	    'default' => '0.01em',
	    'transport'	=> 'postMessage'
	);

	$options['type-footer-widget-body-word-spacing'] = array(
	    'id' => 'type-footer-widget-body-word-spacing',
	    'label'   => __( 'Word Spacing (px or em)', 'politics-plus' ),
	    'section' => $section,
	    'type'    => 'text',
	    'default' => '0px',
	    'transport'	=> 'postMessage'
	);

/*--------------------------------------------------------------
5.7 Typography: Copyright
--------------------------------------------------------------*/
	$section = 'type-copyright';

	$sections[] = array(
		'id' => $section,
		'title' => __( 'Copyright', 'politics-plus' ),
		'priority' => '35',
		'panel' => $panel
	);

/**
 * Copyright Text
 */
	$options['type-copyright'] = array(
		'id' => 'type-copyright',
    'section' => $section,
    'label'    => '',
    'type'     => 'content',
		'description' 	=> __( 'Font settings for the copyright text', 'politics-plus' )
	);

	$options['type-copyright-font-family'] = array(
		'id' => 'type-copyright-font-family',
		'label'   => __( 'Font Family', 'politics-plus' ),
		'section' => $section,
		'type'    => 'select',
		'choices' => $font_choices,
		'default' => 'Open Sans',
		'transport'	=> 'postMessage'
	);

	$options['type-copyright-font-size'] = array(
	    'id' => 'type-copyright-font-size',
	    'label'   => __( 'Font Size (px or em)', 'politics-plus' ),
	    'section' => $section,
	    'type'    => 'text',
	    'default' => '12px',
	    'transport'	=> 'postMessage'
	);

	$options['type-copyright-font-weight'] = array(
	    'id' 		=> 'type-copyright-font-weight',
	    'label'   	=> __( 'Font Weight', 'politics-plus' ),
	    'section' 	=> $section,
	    'type'    	=> 'select',
	    'choices' 	=> $font_weight,
	    'default' 	=> 'normal',
	    'transport'	=> 'postMessage'
	);

	$options['type-copyright-font-style'] = array(
	    'id' 		=> 'type-copyright-font-style',
	    'label'   	=> __( 'Font Style', 'politics-plus' ),
	    'section' 	=> $section,
	    'type'    	=> 'select',
	    'choices' 	=> $font_style,
	    'default' 	=> 'normal',
	    'transport'	=> 'postMessage'
	);

	$options['type-copyright-text-transform'] = array(
	    'id' 		=> 'type-copyright-text-transform',
	    'label'   	=> __( 'Text Transform', 'politics-plus' ),
	    'section' 	=> $section,
	    'type'    	=> 'select',
	    'choices' 	=> $text_transform,
	    'default' 	=> 'none',
	    'transport'	=> 'postMessage'
	);

	$options['type-copyright-height'] = array(
	    'id' => 'type-copyright-height',
	    'label'   => __( 'Line Height', 'politics-plus' ),
	    'section' => $section,
	    'type'    => 'text',
	    'default' => '1.4',
	    'transport'	=> 'postMessage'
	);

	$options['type-copyright-letter-spacing'] = array(
	    'id' => 'type-copyright-letter-spacing',
	    'label'   => __( 'Letter Spacing (px or em)', 'politics-plus' ),
	    'section' => $section,
	    'type'    => 'text',
	    'default' => '0.01em',
	    'transport'	=> 'postMessage'
	);

	$options['type-copyright-word-spacing'] = array(
	    'id' => 'type-copyright-word-spacing',
	    'label'   => __( 'Word Spacing (px or em)', 'politics-plus' ),
	    'section' => $section,
	    'type'    => 'text',
	    'default' => '0px',
	    'transport'	=> 'postMessage'
	);

/*--------------------------------------------------------------
6.0 Colors
--------------------------------------------------------------*/
	$panel = 'colors';

	$panels[] = array(
	    'id' => $panel,
	    'title' => __( 'Colors', 'politics-plus' ),
	    'priority' => '30'
	);

	$body_font_color		= '#78909c';
	$header_font_color 	= '#465a63';
	$accent_color				= '#ef5350';
	$accent_color_dark  = '#38474d';
	$white							= '#FFFFFF';
	$nav_bg							= '#485b63';
	$nav_link						= '#455a64';
	$silver							= '#EFEFEF';
	$sidebar_content 		= '#b0bec5';
	$copyright					= '#909395';

/*--------------------------------------------------------------
6.1 Colors: Content
--------------------------------------------------------------*/
	$section = 'content';

	$sections[] = array(
		'id' => $section,
		'title' => __( 'Content', 'politics-plus' ),
		'priority' => '40',
		'panel' => $panel,
		'description'	=> __('These are the default content colors. Set the Navigation, Sidebar, and Footer links in their individual settings area.','politics-plus')
	);

	$options['color-headers'] = array(
		'id'				=> 'color-headers',
		'label'			=> __( 'Headers', 'politics-plus' ),
		'section'		=> $section,
		'type'			=> 'color',
		'default'		=> $header_font_color,
		'transport' => 'postMessage'
	);

	$options['color-content'] = array(
		'id'				=> 'color-content',
		'label'			=> __( 'Standard Text', 'politics-plus' ),
		'section'		=> $section,
		'type'			=> 'color',
		'default'		=> $body_font_color,
		'transport' => 'postMessage'
	);

	$options['color-content-link'] = array(
		'id'				=> 'color-content-link',
		'label'			=> __( 'Links', 'politics-plus' ),
		'section'		=> $section,
		'type'			=> 'color',
		'default'		=> $header_font_color,
		'transport' => 'postMessage'
	);

	$options['color-content-link-hover'] = array(
		'id'				=> 'color-content-link-hover',
		'label'			=> __( 'Link Hover', 'politics-plus' ),
		'section'		=> $section,
		'type'			=> 'color',
		'default'		=> $accent_color
	);

	$options['color-content-top-bar'] = array(
		'id'				=> 'color-content-top-bar',
		'label'			=> __( 'Top Bar Background', 'politics-plus' ),
		'section'		=> $section,
		'type'			=> 'color',
		'default'		=> $accent_color_dark,
		'transport' => 'postMessage'
	);

	$options['color-content-body-bg'] = array(
		'id'				=> 'color-content-body-bg',
		'label'			=> __( 'Sitewide Background', 'politics-plus' ),
		'section'		=> $section,
		'type'			=> 'color',
		'default'		=> $white,
		'transport' => 'postMessage'
	);

	$options['color-content-bg'] = array(
		'id'				=> 'color-content-bg',
		'label'			=> __( 'Content Background', 'politics-plus' ),
		'section'		=> $section,
		'type'			=> 'color',
		'default'		=> $white,
		'transport' => 'postMessage'
	);

	$options['color-comments-bg'] = array(
		'id'				=> 'color-comments-bg',
		'label'			=> __( 'Comments Background', 'politics-plus' ),
		'section'		=> $section,
		'type'			=> 'color',
		'default'		=> $white,
		'transport' => 'postMessage'
	);

/*--------------------------------------------------------------
6.2 Colors: Navigation
--------------------------------------------------------------*/
	$section = 'navigation';

	$sections[] = array(
		'id' => $section,
		'title' => __( 'Navigation', 'politics-plus' ),
		'priority' => '45',
		'panel' => $panel
	);

	$options['nav-bg'] = array(
		'id'				=> 'nav-bg',
		'label'			=> __( 'Background', 'politics-plus' ),
		'section'		=> $section,
		'type'			=> 'color',
		'default'		=> $white,
		'transport' => 'postMessage'
	);

	$options['nav-bg-hover'] = array(
		'id'				=> 'nav-bg-hover',
		'label'			=> __( 'Background Hover', 'politics-plus' ),
		'section'		=> $section,
		'type'			=> 'color',
		'default'		=> $nav_bg
	);

	$options['nav-links'] = array(
		'id'				=> 'nav-links',
		'label'			=> __( 'Links', 'politics-plus' ),
		'section'		=> $section,
		'type'			=> 'color',
		'default'		=> $nav_link,
		'transport' => 'postMessage'
	);


	$options['nav-links-hover'] = array(
		'id'				=> 'nav-links-hover',
		'label'			=> __( 'Links Hover', 'politics-plus' ),
		'section'		=> $section,
		'type'			=> 'color',
		'default'		=> $silver
	);

/*--------------------------------------------------------------
6.3 Colors: Title & Tagline
--------------------------------------------------------------*/
	$section = 'colors-title-tagline';

	$sections[] = array(
		'id' => $section,
		'title' => __( 'Title & Tagline', 'politics-plus' ),
		'priority' => '50',
		'panel' => $panel
	);

	$options['color-site-title'] = array(
		'id'				=> 'color-site-title',
		'label'			=> __( 'Title', 'politics-plus' ),
		'section'		=> $section,
		'type'			=> 'color',
		'default'		=> $primary_color_drkblue,
		'transport' => 'postMessage'
	);

	$options['color-site-tagline'] = array(
		'id'				=> 'color-site-tagline',
		'label'			=> __( 'Tagline', 'politics-plus' ),
		'section'		=> $section,
		'type'			=> 'color',
		'default'		=> $body_font_color,
		'transport' => 'postMessage'
	);

/*--------------------------------------------------------------
6.4 Colors: Sidebar
--------------------------------------------------------------*/
	$section = 'colors-sidebar';

	$sections[] = array(
		'id' => $section,
		'title' => __( 'Sidebar', 'politics-plus' ),
		'priority' => '50',
		'panel' => $panel
	);

	$options['color-sidebar-widget-title'] = array(
		'id'				=> 'color-sidebar-widget-title',
		'label'			=> __( 'Widget Title', 'politics-plus' ),
		'section'		=> $section,
		'type'			=> 'color',
		'default'		=> $primary_color_drkblue,
		'transport' => 'postMessage'
	);

	$options['color-sidebar-widget-content'] = array(
		'id'				=> 'color-sidebar-widget-content',
		'label'			=> __( 'Widget Content', 'politics-plus' ),
		'section'		=> $section,
		'type'			=> 'color',
		'default'		=> $sidebar_content,
		'transport' => 'postMessage'
	);

	$options['color-sidebar-widget-links'] = array(
		'id'				=> 'color-sidebar-widget-links',
		'label'			=> __( 'Links', 'politics-plus' ),
		'section'		=> $section,
		'type'			=> 'color',
		'default'		=> $sidebar_content,
		'transport' => 'postMessage'
	);

	$options['color-sidebar-widget-link-hover'] = array(
		'id'				=> 'color-sidebar-widget-link-hover',
		'label'			=> __( 'Link Hover', 'politics-plus' ),
		'section'		=> $section,
		'type'			=> 'color',
		'default'		=> $accent_color
	);

/*--------------------------------------------------------------
6.5 Colors: Footer
--------------------------------------------------------------*/
	$section = 'colors-footer';

	$sections[] = array(
		'id' => $section,
		'title' => __( 'Footer', 'politics-plus' ),
		'priority' => '55',
		'panel' => $panel
	);

	$options['color-footer-bg'] = array(
		'id'				=> 'color-footer-bg',
		'label'			=> __( 'Background', 'politics-plus' ),
		'section'		=> $section,
		'type'			=> 'color',
		'default'		=> $accent_color_dark,
		'transport' => 'postMessage'
	);

	$options['color-footer-widget-title'] = array(
		'id'				=> 'color-footer-widget-title',
		'label'			=> __( 'Widget Title', 'politics-plus' ),
		'section'		=> $section,
		'type'			=> 'color',
		'default'		=> $white,
		'transport' => 'postMessage'
	);

	$options['color-footer-widget-content'] = array(
		'id'				=> 'color-footer-widget-content',
		'label'			=> __( 'Widget content', 'politics-plus' ),
		'section'		=> $section,
		'type'			=> 'color',
		'default'		=> $white,
		'transport' => 'postMessage'
	);

	$options['color-footer-widget-links'] = array(
		'id'				=> 'color-footer-widget-links',
		'label'			=> __( 'Widget Links', 'politics-plus' ),
		'section'		=> $section,
		'type'			=> 'color',
		'default'		=> $white,
		'transport' => 'postMessage'
	);

	$options['color-footer-widget-links-hover'] = array(
		'id'				=> 'color-footer-widget-links-hover',
		'label'			=> __( 'Widget Links Hover', 'politics-plus' ),
		'section'		=> $section,
		'type'			=> 'color',
		'default'		=> $accent_color
	);

	$options['color-copyright-text'] = array(
		'id'				=> 'color-copyright-text',
		'label'			=> __( 'Copyright Text', 'politics-plus' ),
		'section'		=> $section,
		'type'			=> 'color',
		'default'		=> $copyright,
		'transport' => 'postMessage'
	);

	$options['color-copyright-links'] = array(
		'id'				=> 'color-copyright-links',
		'label'			=> __( 'Copyright Links', 'politics-plus' ),
		'section'		=> $section,
		'type'			=> 'color',
		'default'		=> $copyright,
		'transport' => 'postMessage'
	);

	$options['color-copyright-hover'] = array(
		'id'				=> 'color-copyright-hover',
		'label'			=> __( 'Copyright Link Hover', 'politics-plus' ),
		'section'		=> $section,
		'type'			=> 'color',
		'default'		=> $accent_color
	);

/*--------------------------------------------------------------
7.0 Image Effects
--------------------------------------------------------------*/
	$panel = 'image-effects';

	$panels[] = array(
	    'id' => $panel,
	    'title' => __( 'Images', 'politics-plus' ),
	    'priority' => '40'
	);
	$section = 'image-effects';

	$sections[] = array(
		'id' => $section,
		'title' => __( 'Image Effects', 'politics-plus' ),
		'priority' => '60',
		'panel' => $panel
	);

	$options['enable-image-effects'] = array(
		'id'				=> 'enable-image-effects',
		'label'			=> __( 'Enable Image Fade In Effects', 'politics-plus' ),
		'section'		=> $section,
		'type'			=> 'checkbox',
		'default'		=> 1,
	);

	// Adds the sections to the $options array
	$options['sections'] = $sections;

	// Adds the panels to the $options array
	$options['panels'] = $panels;

	// Hook to add the custom customizer in child theme.
	$options= apply_filters( 'politics_plus_add_customizer_child_options' , $options );
	
	$customizer_library = Customizer_Library::Instance();
	$customizer_library->add_options( $options );

	// To delete custom mods use: customizer_library_remove_theme_mods();
	

}
add_action( 'init', 'politics_plus_customizer_library_options' );
