/**
 * Theme Customizer enhancements for a better user experience.
 *
 * Contains handlers to make Theme Customizer preview reload changes asynchronously.
 */

/*--------------------------------------------------------------
>>> TABLE OF CONTENTS:
----------------------------------------------------------------

1.0 Header
2.0 Home
	2.1 Home posts
	2.2 Secondary Content
	2.3 Paralax
	2.4 Slider
3.0 Footer
4.0 Blog
5.0 Typography
	5.1 Typography: Global
	5.2 Typography: Headers
	5.3 Typography: Site Title & Tagline
	5.4 Typography: Navigation
	5.5 Typography: Sidebar
	5.6 Typography: Footer
	5.7 Typography: Copyright
6.0 Colors
	6.1 Colors: Sitewide
	6.2 Colors: Navigation
	6.3 Colors: Title & Tagline
	6.4 Colors: Sidebar
	6.5 Colors: Footer

--------------------------------------------------------------*/

(function ($) {

/*--------------------------------------------------------------
1.0 Header
--------------------------------------------------------------*/
	// Site title
	wp.customize( 'blogname', function( value ) {
		value.bind( function( to ) {
			$( '.site-title a' ).text( to );
		} );
	} );

	// Site description
	wp.customize( 'blogdescription', function( value ) {
		value.bind( function( to ) {
			$( '.site-description' ).text( to );
		} );
	} );

	// Phone number
	wp.customize( 'politics-plus-header-phone', function( value ) {
		value.bind( function( to ) {
			$( '.header-contact .header-phone a span' ).text( to );
		} );
	} );

	// Location
	wp.customize( 'politics-plus-header-address', function( value ) {
		value.bind( function( to ) {
			$( '.header-contact .header-address a span' ).text( to );
		} );
	} );

/*--------------------------------------------------------------
2.0 Home
--------------------------------------------------------------*/
	// Home: Featured Posts Title
	wp.customize( 'home_posts_section_title', function( value ) {
		value.bind( function( to ) {
			$( '.home_posts_titles h2' ).text( to );
		} );
	} );

	// Home: Featured Posts Subtitle
	wp.customize( 'home_posts_section_subtitle', function( value ) {
		value.bind( function( to ) {
			$( '.home_posts_titles p' ).text( to );
		} );
	} );

	// Home: Secondary Content Title
	wp.customize( 'home_secondary_content_title', function( value ) {
		value.bind( function( to ) {
			$( '.home_secondary_content_header h2' ).text( to );
		} );
	} );

	// Home: Secondary Content Subtitle
	wp.customize( 'home_secondary_content_subtitle', function( value ) {
		value.bind( function( to ) {
			$( '.home_secondary_content_header p' ).text( to );
		} );
	} );

/*--------------------------------------------------------------
3.0 Footer
--------------------------------------------------------------*/
	// Footer Copyright
	wp.customize( 'footer_copyright', function( value ) {
		value.bind( function( to ) {
			$( '.copyright-info' ).text( to );
		} );
	} );

/*--------------------------------------------------------------
4.0 Blog
--------------------------------------------------------------*/
	// Blog page title
	wp.customize( 'politics_plus_blog_title', function( value ) {
		value.bind( function( to ) {
			$( 'h1.page-header-title' ).text( to );
		} );
	} );

	// Blog page subtitle
	wp.customize( 'politics_plus_blog_subtitle', function( value ) {
		value.bind( function( to ) {
			$( 'h2.page-header-subtitle' ).text( to );
		} );
	} );

/*--------------------------------------------------------------
5.0 Typography
--------------------------------------------------------------*/

/*--------------------------------------------------------------
5.1 Typography: Global
--------------------------------------------------------------*/
	// Link Font Weight
	wp.customize( 'type-global-links-weight', function( value ) {
		value.bind( function( to ) {
			$( 'a' ).css( 'font-weight', to );
		} );
	} );

	// Link Underline
	wp.customize( 'type-global-links-underline', function( value ) {
		value.bind( function( to ) {
			$( 'a' ).css( 'text-decoration', to );
		} );
	} );

/*--------------------------------------------------------------
5.2 Typography: Headers
--------------------------------------------------------------*/
	wp.customize( 'type-header-font-family', function( value ) {
		value.bind( function( to ) {
			$( 'h1, h2, h3, h4, h5, h6' ).css( 'font-family', to );
		} );
	} );

	// Font Weight
	wp.customize( 'type-header-font-weight', function( value ) {
		value.bind( function( to ) {
			$( 'h1, h2, h3, h4, h5, h6' ).css( 'font-weight', to );
		} );
	} );

	// Font Style
	wp.customize( 'type-header-font-style', function( value ) {
		value.bind( function( to ) {
			$( 'h1, h2, h3, h4, h5, h6' ).css( 'font-style', to );
		} );
	} );

	// Text Transform
	wp.customize( 'type-header-text-transform', function( value ) {
		value.bind( function( to ) {
			$( 'h1, h2, h3, h4, h5, h6' ).css( 'text-transform', to );
		} );
	} );

	// Line Height
	wp.customize( 'type-header-line-height', function( value ) {
		value.bind( function( to ) {
			$( 'h1, h2, h3, h4, h5, h6' ).css( 'line-height', to );
		} );
	} );

	// Letter Spacing
	wp.customize( 'type-header-letter-spacing', function( value ) {
		value.bind( function( to ) {
			$( 'h1, h2, h3, h4, h5, h6' ).css( 'letter-spacing', to );
		} );
	} );

	// Word Spacing
	wp.customize( 'type-header-word-spacing', function( value ) {
		value.bind( function( to ) {
			$( 'h1, h2, h3, h4, h5, h6' ).css( 'word-spacing', to );
		} );
	} );

/*--------------------------------------------------------------
5.3 Typography: Site Title & Tagline
--------------------------------------------------------------*/
/* Site Title */
	// Site Title: Font Family
	wp.customize( 'type-sitetitle-font-family', function( value ) {
		value.bind( function( to ) {
			$( '.site-header .site-branding h1.site-title' ).css( 'font-family', to );
		} );
	} );

	// Site Title: Font Size
	wp.customize( 'type-sitetitle-font-size', function( value ) {
		value.bind( function( to ) {
			$( '.site-header .site-branding h1.site-title' ).css( 'font-size', to );
		} );
	} );

	// Site Title: Font Weight
	wp.customize( 'type-sitetitle-font-weight', function( value ) {
		value.bind( function( to ) {
			$( '.site-header .site-branding h1.site-title' ).css( 'font-weight', to );
		} );
	} );

	// Site Title: Font Style
	wp.customize( 'type-sitetitle-font-style', function( value ) {
		value.bind( function( to ) {
			$( '.site-header .site-branding h1.site-title' ).css( 'font-style', to );
		} );
	} );

	// Site Title: Text Transform
	wp.customize( 'type-sitetitle-text-transform', function( value ) {
		value.bind( function( to ) {
			$( '.site-header .site-branding h1.site-title' ).css( 'text-transform', to );
		} );
	} );

	// Site Title: Line Height
	wp.customize( 'type-sitetitle-line-height', function( value ) {
		value.bind( function( to ) {
			$( '.site-header .site-branding h1.site-title' ).css( 'line-height', to );
		} );
	} );

	// Site Title: Letter Spacing
	wp.customize( 'type-sitetitle-letter-spacing', function( value ) {
		value.bind( function( to ) {
			$( '.site-header .site-branding h1.site-title' ).css( 'letter-spacing', to );
		} );
	} );

	// Site Title: Word Spacing
	wp.customize( 'type-sitetitle-word-spacing', function( value ) {
		value.bind( function( to ) {
			$( '.site-header .site-branding h1.site-title' ).css( 'word-spacing', to );
		} );
	} );

/* Site Tagline */
	// Site Tagline: Font Family
	wp.customize( 'type-sitetagline-font-family', function( value ) {
		value.bind( function( to ) {
			$( '.site-header .site-branding p.site-description' ).css( 'font-family', to );
		} );
	} );

	// Site Tagline: Font Size
	wp.customize( 'type-sitetagline-font-size', function( value ) {
		value.bind( function( to ) {
			$( '.site-header .site-branding p.site-description' ).css( 'font-size', to );
		} );
	} );

	// Site Tagline: Font Weight
	wp.customize( 'type-sitetagline-font-weight', function( value ) {
		value.bind( function( to ) {
			$( '.site-header .site-branding p.site-description' ).css( 'font-weight', to );
		} );
	} );

	// Site Tagline: Font Style
	wp.customize( 'type-sitetagline-font-style', function( value ) {
		value.bind( function( to ) {
			$( '.site-header .site-branding p.site-description' ).css( 'font-style', to );
		} );
	} );

	// Site Tagline: Text Transform
	wp.customize( 'type-sitetagline-text-transform', function( value ) {
		value.bind( function( to ) {
			$( '.site-header .site-branding p.site-description' ).css( 'text-transform', to );
		} );
	} );

	// Site Tagline: Line Height
	wp.customize( 'type-sitetagline-line-height', function( value ) {
		value.bind( function( to ) {
			$( '.site-header .site-branding p.site-description' ).css( 'line-height', to );
		} );
	} );

	// Site Tagline: Letter Spacing
	wp.customize( 'type-sitetagline-letter-spacing', function( value ) {
		value.bind( function( to ) {
			$( '.site-header .site-branding p.site-description' ).css( 'letter-spacing', to );
		} );
	} );

	// Site Tagline: Word Spacing
	wp.customize( 'type-sitetagline-word-spacing', function( value ) {
		value.bind( function( to ) {
			$( '.site-header .site-branding p.site-description' ).css( 'word-spacing', to );
		} );
	} );

/*--------------------------------------------------------------
5.4 Typography: Navigation
--------------------------------------------------------------*/
wp.customize( 'type-main-menu-font-family', function( value ) {
	value.bind( function( to ) {
		$( '#site-navigation li a' ).css( 'font-family', to );
	} );
} );

// Site Tagline: Font Size
wp.customize( 'type-main-menu-font-size', function( value ) {
	value.bind( function( to ) {
		$( '#site-navigation li a' ).css( 'font-size', to );
	} );
} );

// Site Tagline: Font Weight
wp.customize( 'type-main-menu-font-weight', function( value ) {
	value.bind( function( to ) {
		$( '#site-navigation li a' ).css( 'font-weight', to );
	} );
} );

// Site Tagline: Font Style
wp.customize( 'type-main-menu-font-style', function( value ) {
	value.bind( function( to ) {
		$( '#site-navigation li a' ).css( 'font-style', to );
	} );
} );

// Site Tagline: Text Transform
wp.customize( 'type-main-menu-text-transform', function( value ) {
	value.bind( function( to ) {
		$( '#site-navigation li a' ).css( 'text-transform', to );
	} );
} );

// Site Tagline: Line Height
wp.customize( 'type-main-menu-line-height', function( value ) {
	value.bind( function( to ) {
		$( '#site-navigation .sub-menu li:not(.has-form):not(.active) > a:not(.button)' ).css( 'line-height', to );
	} );
} );

// Site Tagline: Letter Spacing
wp.customize( 'type-main-menu-letter-spacing', function( value ) {
	value.bind( function( to ) {
		$( '#site-navigation li a' ).css( 'letter-spacing', to );
	} );
} );

// Site Tagline: Word Spacing
wp.customize( 'type-main-menu-word-spacing', function( value ) {
	value.bind( function( to ) {
		$( '#site-navigation li a' ).css( 'word-spacing', to );
	} );
} );

/*--------------------------------------------------------------
5.5 Typography: Sidebar
--------------------------------------------------------------*/
// Sidebar Widget Titles: Font Family
wp.customize( 'type-widget-title-font-family', function( value ) {
	value.bind( function( to ) {
		$( '.inner-sidebar h2.widget-title' ).css( 'font-family', to );
	} );
} );

// Sidebar Widget Titles: Font Size
wp.customize( 'type-widget-title-font-size', function( value ) {
	value.bind( function( to ) {
		$( '.inner-sidebar h2.widget-title' ).css( 'font-size', to );
	} );
} );

// Sidebar Widget Titles: Font Weight
wp.customize( 'type-widget-title-font-weight', function( value ) {
	value.bind( function( to ) {
		$( '.inner-sidebar h2.widget-title' ).css( 'font-weight', to );
	} );
} );

// Sidebar Widget Titles: Font Style
wp.customize( 'type-widget-title-font-style', function( value ) {
	value.bind( function( to ) {
		$( '.inner-sidebar h2.widget-title' ).css( 'font-style', to );
	} );
} );

// Sidebar Widget Titles: Text Transform
wp.customize( 'type-widget-title-text-transform', function( value ) {
	value.bind( function( to ) {
		$( '.inner-sidebar h2.widget-title' ).css( 'text-transform', to );
	} );
} );

// Sidebar Widget Titles: Line Height
wp.customize( 'type-widget-title-line-height', function( value ) {
	value.bind( function( to ) {
		$( '.inner-sidebar h2.widget-title' ).css( 'line-height', to );
	} );
} );

// Sidebar Widget Titles: Letter Spacing
wp.customize( 'type-widget-title-letter-spacing', function( value ) {
	value.bind( function( to ) {
		$( '.inner-sidebar h2.widget-title' ).css( 'letter-spacing', to );
	} );
} );

// Sidebar Widget Titles: Word Spacing
wp.customize( 'type-widget-title-word-spacing', function( value ) {
	value.bind( function( to ) {
		$( '.inner-sidebar h2.widget-title' ).css( 'word-spacing', to );
	} );
} );

/*-- Typography: Sidebar Widget Body --*/
	// Sidebar Widget Title: Font Family
	wp.customize( 'type-widget-body-font-family', function( value ) {
		value.bind( function( to ) {
			$( '.widget-area aside, .widget-area aside ul, .widget-area aside li, .widget-area aside p' ).css( 'font-family', to );
		} );
	} );

	// Sidebar Widget Title: Font Size
	wp.customize( 'type-widget-body-font-size', function( value ) {
		value.bind( function( to ) {
			$( '.widget-area aside, .widget-area aside ul, .widget-area aside li, .widget-area aside p' ).css( 'font-size', to );
		} );
	} );

	// Sidebar Widget Title: Font Weight
	wp.customize( 'type-widget-body-font-weight', function( value ) {
		value.bind( function( to ) {
			$( '.widget-area aside, .widget-area aside ul, .widget-area aside li, .widget-area aside p' ).css( 'font-weight', to );
		} );
	} );

	// Sidebar Widget Title: Font Style
	wp.customize( 'type-widget-body-font-style', function( value ) {
		value.bind( function( to ) {
			$( '.widget-area aside' ).css( 'font-style', to );
		} );
	} );

	// Sidebar Widget Title: Text Transform
	wp.customize( 'type-widget-body-text-transform', function( value ) {
		value.bind( function( to ) {
			$( '.widget-area aside, .widget-area aside ul, .widget-area aside li, .widget-area aside p' ).css( 'text-transform', to );
		} );
	} );

	// Sidebar Widget Title: Line Height
	wp.customize( 'type-widget-body-line-height', function( value ) {
		value.bind( function( to ) {
			$( '.widget-area aside, .widget-area aside ul, .widget-area aside li, .widget-area aside p' ).css( 'line-height', to );
		} );
	} );

	// Sidebar Widget Title: Letter Spacing
	wp.customize( 'type-widget-body-letter-spacing', function( value ) {
		value.bind( function( to ) {
			$( '.widget-area aside, .widget-area aside ul, .widget-area aside li, .widget-area aside p' ).css( 'letter-spacing', to );
		} );
	} );

	// Sidebar Widget Title: Word Spacing
	wp.customize( 'type-widget-body-word-spacing', function( value ) {
		value.bind( function( to ) {
			$( '.widget-area aside, .widget-area aside ul, .widget-area aside li, .widget-area aside p' ).css( 'word-spacing', to );
		} );
	} );

/*--------------------------------------------------------------
5.6 Typography: Footer
--------------------------------------------------------------*/
	// Footer Widget Titles: Font Family
	wp.customize( 'type-footer-widget-title-font-family', function( value ) {
		value.bind( function( to ) {
			$( '.footer-wrap .widget-title' ).css( 'font-family', to );
		} );
	} );

	// Footer Widget Titles: Font Size
	wp.customize( 'type-footer-widget-title-font-size', function( value ) {
		value.bind( function( to ) {
			$( '.footer-wrap .widget-title' ).css( 'font-size', to );
		} );
	} );

	// Footer Widget Titles: Font Weight
	wp.customize( 'type-footer-widget-title-font-weight', function( value ) {
		value.bind( function( to ) {
			$( '.footer-wrap .widget-title' ).css( 'font-weight', to );
		} );
	} );

	// Footer Widget Titles: Font Style
	wp.customize( 'type-footer-widget-title-font-style', function( value ) {
		value.bind( function( to ) {
			$( '.footer-wrap .widget-title' ).css( 'font-style', to );
		} );
	} );

	// Footer Widget Titles: Text Transform
	wp.customize( 'type-footer-widget-title-text-transform', function( value ) {
		value.bind( function( to ) {
			$( '.footer-wrap .widget-title' ).css( 'text-transform', to );
		} );
	} );

	// Footer Widget Titles: Line Height
	wp.customize( 'type-footer-widget-title-line-height', function( value ) {
		value.bind( function( to ) {
			$( '.footer-wrap .widget-title' ).css( 'line-height', to );
		} );
	} );

	// Footer Widget Titles: Letter Spacing
	wp.customize( 'type-footer-widget-title-letter-spacing', function( value ) {
		value.bind( function( to ) {
			$( '.footer-wrap .widget-title' ).css( 'letter-spacing', to );
		} );
	} );

	// Footer Widget Titles: Word Spacing
	wp.customize( 'type-footer-widget-title-word-spacing', function( value ) {
		value.bind( function( to ) {
			$( '.footer-wrap .widget-title' ).css( 'word-spacing', to );
		} );
	} );

/*-- Footer Widget Body --*/
	// Footer Widget Body: Font Family
	wp.customize( 'type-footer-widget-body-font-family', function( value ) {
		value.bind( function( to ) {
			$( '.site-footer aside ul, .site-footer aside li, .site-footer aside p, .site-footer aside .textwidget' ).css( 'font-family', to );
		} );
	} );

	// Footer Widget Body: Font Size
	wp.customize( 'type-footer-widget-body-font-size', function( value ) {
		value.bind( function( to ) {
			$( '.site-footer aside ul, .site-footer aside li, .site-footer aside p, .site-footer aside .textwidget' ).css( 'font-size', to );
		} );
	} );

	// Footer Widget Body: Font Weight
	wp.customize( 'type-footer-widget-body-font-weight', function( value ) {
		value.bind( function( to ) {
			$( '.site-footer aside, .site-footer aside ul, .site-footer aside li, .site-footer aside p, .site-footer aside .textwidget' ).css( 'font-weight', to );
		} );
	} );

	// Footer Widget Body: Font Style
	wp.customize( 'type-footer-widget-body-font-style', function( value ) {
		value.bind( function( to ) {
			$( '.site-footer aside ul, .site-footer aside li, .site-footer aside p, .site-footer aside .textwidget' ).css( 'font-style', to );
		} );
	} );

	// Footer Widget Body: Text Transform
	wp.customize( 'type-footer-widget-body-text-transform', function( value ) {
		value.bind( function( to ) {
			$( '.site-footer aside ul, .site-footer aside li, .site-footer aside p, .site-footer aside .textwidget' ).css( 'text-transform', to );
		} );
	} );

	// Footer Widget Body: Line Height
	wp.customize( 'type-footer-widget-body-line-height', function( value ) {
		value.bind( function( to ) {
			$( '.site-footer aside ul, .site-footer aside li, .site-footer aside p, .site-footer aside .textwidget' ).css( 'line-height', to );
		} );
	} );

	// Footer Widget Body: Letter Spacing
	wp.customize( 'type-footer-widget-body-letter-spacing', function( value ) {
		value.bind( function( to ) {
			$( '.site-footer aside ul, .site-footer aside li, .site-footer aside p, .site-footer aside .textwidget' ).css( 'letter-spacing', to );
		} );
	} );

	// Footer Widget Body: Word Spacing
	wp.customize( 'type-footer-widget-body-word-spacing', function( value ) {
		value.bind( function( to ) {
			$( '.site-footer aside ul, .site-footer aside li, .site-footer aside p, .site-footer aside .textwidget' ).css( 'word-spacing', to );
		} );
	} );

/*--------------------------------------------------------------
5.7 Typography: Copyright
--------------------------------------------------------------*/
	// Font Family
	wp.customize( 'type-copyright-font-family', function( value ) {
		value.bind( function( to ) {
			$( '.copyright-info, .copyright-info p, .copyright-info a' ).css( 'font-family', to );
		} );
	} );

	// Font Size
	wp.customize( 'type-copyright-font-size', function( value ) {
		value.bind( function( to ) {
			$( '.copyright-info, .copyright-info p, .copyright-info a' ).css( 'font-size', to );
		} );
	} );

	// Font Weight
	wp.customize( 'type-copyright-font-weight', function( value ) {
		value.bind( function( to ) {
			$( '.copyright-info, .copyright-info p, .copyright-info a' ).css( 'font-weight', to );
		} );
	} );

	// Font Style
	wp.customize( 'type-copyright-font-style', function( value ) {
		value.bind( function( to ) {
			$( '.copyright-info, .copyright-info p, .copyright-info a' ).css( 'font-style', to );
		} );
	} );

	// Text Transform
	wp.customize( 'type-copyright-text-transform', function( value ) {
		value.bind( function( to ) {
			$( '.copyright-info, .copyright-info p, .copyright-info a' ).css( 'text-transform', to );
		} );
	} );

	// Line Height
	wp.customize( 'type-copyright-line-height', function( value ) {
		value.bind( function( to ) {
			$( '.copyright-info, .copyright-info p, .copyright-info a' ).css( 'line-height', to );
		} );
	} );

	// Letter Spacing
	wp.customize( 'type-copyright-letter-spacing', function( value ) {
		value.bind( function( to ) {
			$( '.copyright-info, .copyright-info p, .copyright-info a' ).css( 'letter-spacing', to );
		} );
	} );

	// Word Spacing
	wp.customize( 'type-copyright-word-spacing', function( value ) {
		value.bind( function( to ) {
			$( '.copyright-info, .copyright-info p, .copyright-info a' ).css( 'word-spacing', to );
		} );
	} );

/*--------------------------------------------------------------
6.1 Colors: Sitewide
--------------------------------------------------------------*/
	wp.customize( 'color-headers', function( value ) {
		value.bind( function( to ) {
			$( '.content-area h1, .content-area h2, .content-area h3, .content-area h4, .content-area h5, .content-area h6, .page-header h1' ).css( 'color', to );
		} );
	} );

	wp.customize( 'color-content', function( value ) {
		value.bind( function( to ) {
			$( '.entry-content p, .comment_content p' ).css( 'color', to );
		} );
	} );

	wp.customize( 'color-content-link', function( value ) {
		value.bind( function( to ) {
			$( '#content a, .hero-widgets-wrap a' ).css( 'color', to );
		} );
	} );

	wp.customize( 'color-content-top-bar', function( value ) {
		value.bind( function( to ) {
			$( '.mini-header' ).css( 'background-color', to );
		} );
	} );

	wp.customize( 'color-content-body-bg', function( value ) {
		value.bind( function( to ) {
			$( 'body, .home .content-area' ).css( 'background-color', to );
		} );
	} );

	wp.customize( 'color-content-bg', function( value ) {
		value.bind( function( to ) {
			$( '#page .site-content .row' ).css( 'background-color', to );
		} );
	} );

	wp.customize( 'color-comments-bg', function( value ) {
		value.bind( function( to ) {
			$( '#comments ol.comment-list .comment-content-wrap' ).css( 'background-color', to );
		} );
	} );

/*--------------------------------------------------------------
6.2 Colors: Navigation
--------------------------------------------------------------*/
	wp.customize( 'nav-bg', function( value ) {
		value.bind( function( to ) {
			$( 'header#masthead, header#masthead.stick, #site-navigation li, .mini-header-wrap' ).css( 'background-color', to );
		} );
	} );

	wp.customize( 'nav-links', function( value ) {
		value.bind( function( to ) {
			$( '#site-navigation li a' ).css( 'color', to );
		} );
	} );

/*--------------------------------------------------------------
6.3 Colors: Title & Tagline
--------------------------------------------------------------*/
	wp.customize( 'color-site-title', function( value ) {
		value.bind( function( to ) {
			$( '.site-header .site-branding h1.site-title a' ).css( 'color', to );
		} );
	} );

	wp.customize( 'color-site-tagline', function( value ) {
		value.bind( function( to ) {
			$( '.site-header .site-branding p.site-description' ).css( 'color', to );
		} );
	} );

/*--------------------------------------------------------------
6.4 Colors: Sidebar
--------------------------------------------------------------*/
	wp.customize( 'color-sidebar-widget-title', function( value ) {
		value.bind( function( to ) {
			$( '.inner-sidebar h2.widget-title' ).css( 'color', to );
		} );
	} );

	wp.customize( 'color-sidebar-widget-content', function( value ) {
		value.bind( function( to ) {
			$( '.inner-sidebar aside' ).css( 'color', to );
		} );
	} );

	wp.customize( 'color-sidebar-widget-links', function( value ) {
		value.bind( function( to ) {
			$( '.inner-sidebar aside a' ).css( 'color', to );
		} );
	} );

/*--------------------------------------------------------------
6.5 Colors: Footer
--------------------------------------------------------------*/
	wp.customize( 'color-footer-bg', function( value ) {
		value.bind( function( to ) {
			$( '.footer-wrap' ).css( 'background-color', to );
		} );
	} );

	wp.customize( 'color-footer-widget-title', function( value ) {
		value.bind( function( to ) {
			$( '.footer-wrap .widget-title' ).css( 'color', to );
		} );
	} );

	wp.customize( 'color-footer-widget-content', function( value ) {
		value.bind( function( to ) {
			$( '.site-footer aside' ).css( 'color', to );
		} );
	} );

	wp.customize( 'color-footer-widget-links', function( value ) {
		value.bind( function( to ) {
			$( '.site-footer aside a' ).css( 'color', to );
		} );
	} );

	wp.customize( 'color-copyright-text', function( value ) {
		value.bind( function( to ) {
			$( '.footer-wrap .copyright-info' ).css( 'color', to );
		} );
	} );

	wp.customize( 'color-copyright-links', function( value ) {
		value.bind( function( to ) {
			$( '.footer-wrap .copyright-info a' ).css( 'color', to );
		} );
	} );


} )( jQuery );
