<?php 
/**
* Plugin Main Class
*/
if ( ! defined( 'ABSPATH' ) ) exit; 
class VC_Image_Hover_Effects_Free  
{
	
	function __construct()
	{
		add_action('vc_before_init', array($this, 'wdo_option_settings'));
		add_shortcode( 'image-hover-effects-vc-free', array( $this, 'render_image_hover_shortcode' ) );
		add_action( 'init', array( $this, 'check_if_vc_is_install' ) );
		add_action( "admin_enqueue_scripts", array( $this, "ihe_custom_param_styles" ) );
		
	}

	function ihe_custom_param_styles() {
		echo '<style type="text/css">
				.wdo_items_to_show.vc_shortcode-param {
					background: #e6e6e652;
					padding: 20px;
				}
				.wdo_items_to_show.wdo_margin_bottom{
					margin-bottom: 15px;
				}
				.wdo_items_to_show.wdo_padding_top{
					padding-top: 15px;
				}
			</style>';
	}

	function wdo_option_settings(){
		include 'includes/setting-options.php'; 


		$ihe_main_var = array(
			"name" => __("Image Hover Effects"),
			"base" => "image-hover-effects-vc-free",
			"category" => __('by labibahmed'),
			"description" => __('Insert Images with Hover Effects'),
			"params" => $settings_params 
		);

		vc_map($ihe_main_var);
	}

	function render_image_hover_shortcode($attrs, $content = null){ 
		extract(shortcode_atts( array(
		    'ihe_heading'					=> "",
		    "caption_url"					=> '',
		    "caption_url_target"			=> '',
		    "ihe_image"						=> '',
		    "caption_style"					=> 'circle',
		    "hover_effect"					=> 'effect1',
		    "caption_direction"				=> 'left_to_right',
		     "caption_direction_square"		=> 'top_to_bottom',
		), $attrs));

		wp_enqueue_style( 'image-hover-css-free', plugins_url( 'css/image-hover.css' , __FILE__ ));

		$content = wpb_js_remove_wpautop($content, true);
		if ($ihe_image != '') {
			$image_url = wp_get_attachment_url( $ihe_image );		
		}
		ob_start();
		include 'includes/render_hover_effects.php'; 
		return ob_get_clean();
	}


	function check_if_vc_is_install(){
		if ( ! defined( 'WPB_VC_VERSION' ) ) {
            // Display notice that Visual Compser is required
            add_action('admin_notices', array( $this, 'showVcVersionNotice' ));
            return;
        }
	}

	function showVcVersionNotice() {
        $plugin_name = 'Image Hover Effects - WPBakery Addon Free Version';
        echo '
        <div class="updated">
          <p>'.sprintf(__('<strong>%s</strong> requires <strong><a href="https://1.envato.market/XPX54" target="_blank">WPBakery Page Builder</a></strong> plugin to be installed and activated on your site.', 'vc-image-hover'), $plugin_name).'</p>
        </div>';
    }
}
 ?>